/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.BoundaryScanner;
import co.elastic.clients.elasticsearch.core.search.HighlightField;
import co.elastic.clients.elasticsearch.core.search.HighlighterEncoder;
import co.elastic.clients.elasticsearch.core.search.HighlighterFragmenter;
import co.elastic.clients.elasticsearch.core.search.HighlighterOrder;
import co.elastic.clients.elasticsearch.core.search.HighlighterTagsSchema;
import co.elastic.clients.elasticsearch.core.search.HighlighterType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Highlight
implements JsonpSerializable {
    private final Map<String, HighlightField> fields;
    @Nullable
    private final HighlighterType type;
    @Nullable
    private final String boundaryChars;
    @Nullable
    private final Integer boundaryMaxScan;
    @Nullable
    private final BoundaryScanner boundaryScanner;
    @Nullable
    private final String boundaryScannerLocale;
    @Nullable
    private final HighlighterEncoder encoder;
    @Nullable
    private final HighlighterFragmenter fragmenter;
    @Nullable
    private final Integer fragmentOffset;
    @Nullable
    private final Integer fragmentSize;
    @Nullable
    private final Integer maxFragmentLength;
    @Nullable
    private final Integer noMatchSize;
    @Nullable
    private final Integer numberOfFragments;
    @Nullable
    private final HighlighterOrder order;
    @Nullable
    private final List<String> postTags;
    @Nullable
    private final List<String> preTags;
    @Nullable
    private final Boolean requireFieldMatch;
    @Nullable
    private final HighlighterTagsSchema tagsSchema;
    @Nullable
    private final Query highlightQuery;
    @Nullable
    private final String maxAnalyzedOffset;
    public static final JsonpDeserializer<Highlight> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Highlight::setupHighlightDeserializer, Builder::build);

    public Highlight(Builder builder) {
        this.fields = ModelTypeHelper.unmodifiableNonNull(builder.fields, "fields");
        this.type = builder.type;
        this.boundaryChars = builder.boundaryChars;
        this.boundaryMaxScan = builder.boundaryMaxScan;
        this.boundaryScanner = builder.boundaryScanner;
        this.boundaryScannerLocale = builder.boundaryScannerLocale;
        this.encoder = builder.encoder;
        this.fragmenter = builder.fragmenter;
        this.fragmentOffset = builder.fragmentOffset;
        this.fragmentSize = builder.fragmentSize;
        this.maxFragmentLength = builder.maxFragmentLength;
        this.noMatchSize = builder.noMatchSize;
        this.numberOfFragments = builder.numberOfFragments;
        this.order = builder.order;
        this.postTags = ModelTypeHelper.unmodifiable(builder.postTags);
        this.preTags = ModelTypeHelper.unmodifiable(builder.preTags);
        this.requireFieldMatch = builder.requireFieldMatch;
        this.tagsSchema = builder.tagsSchema;
        this.highlightQuery = builder.highlightQuery;
        this.maxAnalyzedOffset = builder.maxAnalyzedOffset;
    }

    public Highlight(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, HighlightField> fields() {
        return this.fields;
    }

    @Nullable
    public HighlighterType type() {
        return this.type;
    }

    @Nullable
    public String boundaryChars() {
        return this.boundaryChars;
    }

    @Nullable
    public Integer boundaryMaxScan() {
        return this.boundaryMaxScan;
    }

    @Nullable
    public BoundaryScanner boundaryScanner() {
        return this.boundaryScanner;
    }

    @Nullable
    public String boundaryScannerLocale() {
        return this.boundaryScannerLocale;
    }

    @Nullable
    public HighlighterEncoder encoder() {
        return this.encoder;
    }

    @Nullable
    public HighlighterFragmenter fragmenter() {
        return this.fragmenter;
    }

    @Nullable
    public Integer fragmentOffset() {
        return this.fragmentOffset;
    }

    @Nullable
    public Integer fragmentSize() {
        return this.fragmentSize;
    }

    @Nullable
    public Integer maxFragmentLength() {
        return this.maxFragmentLength;
    }

    @Nullable
    public Integer noMatchSize() {
        return this.noMatchSize;
    }

    @Nullable
    public Integer numberOfFragments() {
        return this.numberOfFragments;
    }

    @Nullable
    public HighlighterOrder order() {
        return this.order;
    }

    @Nullable
    public List<String> postTags() {
        return this.postTags;
    }

    @Nullable
    public List<String> preTags() {
        return this.preTags;
    }

    @Nullable
    public Boolean requireFieldMatch() {
        return this.requireFieldMatch;
    }

    @Nullable
    public HighlighterTagsSchema tagsSchema() {
        return this.tagsSchema;
    }

    @Nullable
    public Query highlightQuery() {
        return this.highlightQuery;
    }

    @Nullable
    public String maxAnalyzedOffset() {
        return this.maxAnalyzedOffset;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fields");
        generator.writeStartObject();
        for (Map.Entry<String, HighlightField> entry : this.fields.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
        if (this.boundaryChars != null) {
            generator.writeKey("boundary_chars");
            generator.write(this.boundaryChars);
        }
        if (this.boundaryMaxScan != null) {
            generator.writeKey("boundary_max_scan");
            generator.write(this.boundaryMaxScan.intValue());
        }
        if (this.boundaryScanner != null) {
            generator.writeKey("boundary_scanner");
            this.boundaryScanner.serialize(generator, mapper);
        }
        if (this.boundaryScannerLocale != null) {
            generator.writeKey("boundary_scanner_locale");
            generator.write(this.boundaryScannerLocale);
        }
        if (this.encoder != null) {
            generator.writeKey("encoder");
            this.encoder.serialize(generator, mapper);
        }
        if (this.fragmenter != null) {
            generator.writeKey("fragmenter");
            this.fragmenter.serialize(generator, mapper);
        }
        if (this.fragmentOffset != null) {
            generator.writeKey("fragment_offset");
            generator.write(this.fragmentOffset.intValue());
        }
        if (this.fragmentSize != null) {
            generator.writeKey("fragment_size");
            generator.write(this.fragmentSize.intValue());
        }
        if (this.maxFragmentLength != null) {
            generator.writeKey("max_fragment_length");
            generator.write(this.maxFragmentLength.intValue());
        }
        if (this.noMatchSize != null) {
            generator.writeKey("no_match_size");
            generator.write(this.noMatchSize.intValue());
        }
        if (this.numberOfFragments != null) {
            generator.writeKey("number_of_fragments");
            generator.write(this.numberOfFragments.intValue());
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.postTags != null) {
            generator.writeKey("post_tags");
            generator.writeStartArray();
            for (String string : this.postTags) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.preTags != null) {
            generator.writeKey("pre_tags");
            generator.writeStartArray();
            for (String string : this.preTags) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.requireFieldMatch != null) {
            generator.writeKey("require_field_match");
            generator.write(this.requireFieldMatch.booleanValue());
        }
        if (this.tagsSchema != null) {
            generator.writeKey("tags_schema");
            this.tagsSchema.serialize(generator, mapper);
        }
        if (this.highlightQuery != null) {
            generator.writeKey("highlight_query");
            this.highlightQuery.serialize(generator, mapper);
        }
        if (this.maxAnalyzedOffset != null) {
            generator.writeKey("max_analyzed_offset");
            generator.write(this.maxAnalyzedOffset);
        }
    }

    protected static void setupHighlightDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(HighlightField._DESERIALIZER), "fields", new String[0]);
        op.add(Builder::type, HighlighterType._DESERIALIZER, "type", new String[0]);
        op.add(Builder::boundaryChars, JsonpDeserializer.stringDeserializer(), "boundary_chars", new String[0]);
        op.add(Builder::boundaryMaxScan, JsonpDeserializer.integerDeserializer(), "boundary_max_scan", new String[0]);
        op.add(Builder::boundaryScanner, BoundaryScanner._DESERIALIZER, "boundary_scanner", new String[0]);
        op.add(Builder::boundaryScannerLocale, JsonpDeserializer.stringDeserializer(), "boundary_scanner_locale", new String[0]);
        op.add(Builder::encoder, HighlighterEncoder._DESERIALIZER, "encoder", new String[0]);
        op.add(Builder::fragmenter, HighlighterFragmenter._DESERIALIZER, "fragmenter", new String[0]);
        op.add(Builder::fragmentOffset, JsonpDeserializer.integerDeserializer(), "fragment_offset", new String[0]);
        op.add(Builder::fragmentSize, JsonpDeserializer.integerDeserializer(), "fragment_size", new String[0]);
        op.add(Builder::maxFragmentLength, JsonpDeserializer.integerDeserializer(), "max_fragment_length", new String[0]);
        op.add(Builder::noMatchSize, JsonpDeserializer.integerDeserializer(), "no_match_size", new String[0]);
        op.add(Builder::numberOfFragments, JsonpDeserializer.integerDeserializer(), "number_of_fragments", new String[0]);
        op.add(Builder::order, HighlighterOrder._DESERIALIZER, "order", new String[0]);
        op.add(Builder::postTags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "post_tags", new String[0]);
        op.add(Builder::preTags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "pre_tags", new String[0]);
        op.add(Builder::requireFieldMatch, JsonpDeserializer.booleanDeserializer(), "require_field_match", new String[0]);
        op.add(Builder::tagsSchema, HighlighterTagsSchema._DESERIALIZER, "tags_schema", new String[0]);
        op.add(Builder::highlightQuery, Query._DESERIALIZER, "highlight_query", new String[0]);
        op.add(Builder::maxAnalyzedOffset, JsonpDeserializer.stringDeserializer(), "max_analyzed_offset", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Highlight> {
        private Map<String, HighlightField> fields;
        @Nullable
        private HighlighterType type;
        @Nullable
        private String boundaryChars;
        @Nullable
        private Integer boundaryMaxScan;
        @Nullable
        private BoundaryScanner boundaryScanner;
        @Nullable
        private String boundaryScannerLocale;
        @Nullable
        private HighlighterEncoder encoder;
        @Nullable
        private HighlighterFragmenter fragmenter;
        @Nullable
        private Integer fragmentOffset;
        @Nullable
        private Integer fragmentSize;
        @Nullable
        private Integer maxFragmentLength;
        @Nullable
        private Integer noMatchSize;
        @Nullable
        private Integer numberOfFragments;
        @Nullable
        private HighlighterOrder order;
        @Nullable
        private List<String> postTags;
        @Nullable
        private List<String> preTags;
        @Nullable
        private Boolean requireFieldMatch;
        @Nullable
        private HighlighterTagsSchema tagsSchema;
        @Nullable
        private Query highlightQuery;
        @Nullable
        private String maxAnalyzedOffset;

        public Builder fields(Map<String, HighlightField> value) {
            this.fields = value;
            return this;
        }

        public Builder putFields(String key, HighlightField value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, HighlightField>();
            }
            this.fields.put(key, value);
            return this;
        }

        public Builder fields(String key, Function<HighlightField.Builder, ObjectBuilder<HighlightField>> fn) {
            return this.fields(Collections.singletonMap(key, fn.apply(new HighlightField.Builder()).build()));
        }

        public Builder putFields(String key, Function<HighlightField.Builder, ObjectBuilder<HighlightField>> fn) {
            return this.putFields(key, fn.apply(new HighlightField.Builder()).build());
        }

        public Builder type(@Nullable HighlighterType value) {
            this.type = value;
            return this;
        }

        public Builder boundaryChars(@Nullable String value) {
            this.boundaryChars = value;
            return this;
        }

        public Builder boundaryMaxScan(@Nullable Integer value) {
            this.boundaryMaxScan = value;
            return this;
        }

        public Builder boundaryScanner(@Nullable BoundaryScanner value) {
            this.boundaryScanner = value;
            return this;
        }

        public Builder boundaryScannerLocale(@Nullable String value) {
            this.boundaryScannerLocale = value;
            return this;
        }

        public Builder encoder(@Nullable HighlighterEncoder value) {
            this.encoder = value;
            return this;
        }

        public Builder fragmenter(@Nullable HighlighterFragmenter value) {
            this.fragmenter = value;
            return this;
        }

        public Builder fragmentOffset(@Nullable Integer value) {
            this.fragmentOffset = value;
            return this;
        }

        public Builder fragmentSize(@Nullable Integer value) {
            this.fragmentSize = value;
            return this;
        }

        public Builder maxFragmentLength(@Nullable Integer value) {
            this.maxFragmentLength = value;
            return this;
        }

        public Builder noMatchSize(@Nullable Integer value) {
            this.noMatchSize = value;
            return this;
        }

        public Builder numberOfFragments(@Nullable Integer value) {
            this.numberOfFragments = value;
            return this;
        }

        public Builder order(@Nullable HighlighterOrder value) {
            this.order = value;
            return this;
        }

        public Builder postTags(@Nullable List<String> value) {
            this.postTags = value;
            return this;
        }

        public Builder postTags(String ... value) {
            this.postTags = Arrays.asList(value);
            return this;
        }

        public Builder addPostTags(String value) {
            if (this.postTags == null) {
                this.postTags = new ArrayList<String>();
            }
            this.postTags.add(value);
            return this;
        }

        public Builder preTags(@Nullable List<String> value) {
            this.preTags = value;
            return this;
        }

        public Builder preTags(String ... value) {
            this.preTags = Arrays.asList(value);
            return this;
        }

        public Builder addPreTags(String value) {
            if (this.preTags == null) {
                this.preTags = new ArrayList<String>();
            }
            this.preTags.add(value);
            return this;
        }

        public Builder requireFieldMatch(@Nullable Boolean value) {
            this.requireFieldMatch = value;
            return this;
        }

        public Builder tagsSchema(@Nullable HighlighterTagsSchema value) {
            this.tagsSchema = value;
            return this;
        }

        public Builder highlightQuery(@Nullable Query value) {
            this.highlightQuery = value;
            return this;
        }

        public Builder highlightQuery(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.highlightQuery(fn.apply(new Query.Builder()).build());
        }

        public Builder maxAnalyzedOffset(@Nullable String value) {
            this.maxAnalyzedOffset = value;
            return this;
        }

        @Override
        public Highlight build() {
            return new Highlight(this);
        }
    }
}

