/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.InnerHits;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FieldCollapse
implements JsonpSerializable {
    private final String field;
    @Nullable
    private final List<InnerHits> innerHits;
    @Nullable
    private final Integer maxConcurrentGroupSearches;
    public static final JsonpDeserializer<FieldCollapse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldCollapse::setupFieldCollapseDeserializer, Builder::build);

    public FieldCollapse(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.innerHits = ModelTypeHelper.unmodifiable(builder.innerHits);
        this.maxConcurrentGroupSearches = builder.maxConcurrentGroupSearches;
    }

    public FieldCollapse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public List<InnerHits> innerHits() {
        return this.innerHits;
    }

    @Nullable
    public Integer maxConcurrentGroupSearches() {
        return this.maxConcurrentGroupSearches;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.innerHits != null) {
            generator.writeKey("inner_hits");
            generator.writeStartArray();
            for (InnerHits item0 : this.innerHits) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxConcurrentGroupSearches != null) {
            generator.writeKey("max_concurrent_group_searches");
            generator.write(this.maxConcurrentGroupSearches.intValue());
        }
    }

    protected static void setupFieldCollapseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::innerHits, JsonpDeserializer.arrayDeserializer(InnerHits._DESERIALIZER), "inner_hits", new String[0]);
        op.add(Builder::maxConcurrentGroupSearches, JsonpDeserializer.integerDeserializer(), "max_concurrent_group_searches", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldCollapse> {
        private String field;
        @Nullable
        private List<InnerHits> innerHits;
        @Nullable
        private Integer maxConcurrentGroupSearches;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder innerHits(@Nullable List<InnerHits> value) {
            this.innerHits = value;
            return this;
        }

        public Builder innerHits(InnerHits ... value) {
            this.innerHits = Arrays.asList(value);
            return this;
        }

        public Builder addInnerHits(InnerHits value) {
            if (this.innerHits == null) {
                this.innerHits = new ArrayList<InnerHits>();
            }
            this.innerHits.add(value);
            return this;
        }

        public Builder innerHits(Function<InnerHits.Builder, ObjectBuilder<InnerHits>> fn) {
            return this.innerHits(fn.apply(new InnerHits.Builder()).build());
        }

        public Builder addInnerHits(Function<InnerHits.Builder, ObjectBuilder<InnerHits>> fn) {
            return this.addInnerHits(fn.apply(new InnerHits.Builder()).build());
        }

        public Builder maxConcurrentGroupSearches(@Nullable Integer value) {
            this.maxConcurrentGroupSearches = value;
            return this;
        }

        @Override
        public FieldCollapse build() {
            return new FieldCollapse(this);
        }
    }
}

