/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Collector
implements JsonpSerializable {
    private final String name;
    private final String reason;
    private final long timeInNanos;
    @Nullable
    private final List<Collector> children;
    public static final JsonpDeserializer<Collector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Collector::setupCollectorDeserializer, Builder::build);

    public Collector(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.reason = Objects.requireNonNull(builder.reason, "reason");
        this.timeInNanos = Objects.requireNonNull(builder.timeInNanos, "time_in_nanos");
        this.children = ModelTypeHelper.unmodifiable(builder.children);
    }

    public Collector(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public String reason() {
        return this.reason;
    }

    public long timeInNanos() {
        return this.timeInNanos;
    }

    @Nullable
    public List<Collector> children() {
        return this.children;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
        if (this.children != null) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (Collector item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCollectorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason", new String[0]);
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos", new String[0]);
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Collector> {
        private String name;
        private String reason;
        private Long timeInNanos;
        @Nullable
        private List<Collector> children;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        public Builder children(@Nullable List<Collector> value) {
            this.children = value;
            return this;
        }

        public Builder children(Collector ... value) {
            this.children = Arrays.asList(value);
            return this;
        }

        public Builder addChildren(Collector value) {
            if (this.children == null) {
                this.children = new ArrayList<Collector>();
            }
            this.children.add(value);
            return this;
        }

        public Builder children(Function<Builder, ObjectBuilder<Collector>> fn) {
            return this.children(fn.apply(new Builder()).build());
        }

        public Builder addChildren(Function<Builder, ObjectBuilder<Collector>> fn) {
            return this.addChildren(fn.apply(new Builder()).build());
        }

        @Override
        public Collector build() {
            return new Collector(this);
        }
    }
}

