/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.AggregationBreakdown;
import co.elastic.clients.elasticsearch.core.search.AggregationProfileDebug;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AggregationProfile
implements JsonpSerializable {
    private final AggregationBreakdown breakdown;
    private final String description;
    private final long timeInNanos;
    private final String type;
    @Nullable
    private final AggregationProfileDebug debug;
    @Nullable
    private final List<AggregationProfileDebug> children;
    public static final JsonpDeserializer<AggregationProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AggregationProfile::setupAggregationProfileDeserializer, Builder::build);

    public AggregationProfile(Builder builder) {
        this.breakdown = Objects.requireNonNull(builder.breakdown, "breakdown");
        this.description = Objects.requireNonNull(builder.description, "description");
        this.timeInNanos = Objects.requireNonNull(builder.timeInNanos, "time_in_nanos");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.debug = builder.debug;
        this.children = ModelTypeHelper.unmodifiable(builder.children);
    }

    public AggregationProfile(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AggregationBreakdown breakdown() {
        return this.breakdown;
    }

    public String description() {
        return this.description;
    }

    public long timeInNanos() {
        return this.timeInNanos;
    }

    public String type() {
        return this.type;
    }

    @Nullable
    public AggregationProfileDebug debug() {
        return this.debug;
    }

    @Nullable
    public List<AggregationProfileDebug> children() {
        return this.children;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("breakdown");
        this.breakdown.serialize(generator, mapper);
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
        generator.writeKey("type");
        generator.write(this.type);
        if (this.debug != null) {
            generator.writeKey("debug");
            this.debug.serialize(generator, mapper);
        }
        if (this.children != null) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (AggregationProfileDebug item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupAggregationProfileDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::breakdown, AggregationBreakdown._DESERIALIZER, "breakdown", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(Builder::debug, AggregationProfileDebug._DESERIALIZER, "debug", new String[0]);
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(AggregationProfileDebug._DESERIALIZER), "children", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AggregationProfile> {
        private AggregationBreakdown breakdown;
        private String description;
        private Long timeInNanos;
        private String type;
        @Nullable
        private AggregationProfileDebug debug;
        @Nullable
        private List<AggregationProfileDebug> children;

        public Builder breakdown(AggregationBreakdown value) {
            this.breakdown = value;
            return this;
        }

        public Builder breakdown(Function<AggregationBreakdown.Builder, ObjectBuilder<AggregationBreakdown>> fn) {
            return this.breakdown(fn.apply(new AggregationBreakdown.Builder()).build());
        }

        public Builder description(String value) {
            this.description = value;
            return this;
        }

        public Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder debug(@Nullable AggregationProfileDebug value) {
            this.debug = value;
            return this;
        }

        public Builder debug(Function<AggregationProfileDebug.Builder, ObjectBuilder<AggregationProfileDebug>> fn) {
            return this.debug(fn.apply(new AggregationProfileDebug.Builder()).build());
        }

        public Builder children(@Nullable List<AggregationProfileDebug> value) {
            this.children = value;
            return this;
        }

        public Builder children(AggregationProfileDebug ... value) {
            this.children = Arrays.asList(value);
            return this;
        }

        public Builder addChildren(AggregationProfileDebug value) {
            if (this.children == null) {
                this.children = new ArrayList<AggregationProfileDebug>();
            }
            this.children.add(value);
            return this;
        }

        public Builder children(Function<AggregationProfileDebug.Builder, ObjectBuilder<AggregationProfileDebug>> fn) {
            return this.children(fn.apply(new AggregationProfileDebug.Builder()).build());
        }

        public Builder addChildren(Function<AggregationProfileDebug.Builder, ObjectBuilder<AggregationProfileDebug>> fn) {
            return this.addChildren(fn.apply(new AggregationProfileDebug.Builder()).build());
        }

        @Override
        public AggregationProfile build() {
            return new AggregationProfile(this);
        }
    }
}

