/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AggregationBreakdown
implements JsonpSerializable {
    private final long buildAggregation;
    private final long buildAggregationCount;
    private final long buildLeafCollector;
    private final long buildLeafCollectorCount;
    private final long collect;
    private final long collectCount;
    private final long initialize;
    private final long initializeCount;
    @Nullable
    private final Long postCollection;
    @Nullable
    private final Long postCollectionCount;
    private final long reduce;
    private final long reduceCount;
    public static final JsonpDeserializer<AggregationBreakdown> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AggregationBreakdown::setupAggregationBreakdownDeserializer, Builder::build);

    public AggregationBreakdown(Builder builder) {
        this.buildAggregation = Objects.requireNonNull(builder.buildAggregation, "build_aggregation");
        this.buildAggregationCount = Objects.requireNonNull(builder.buildAggregationCount, "build_aggregation_count");
        this.buildLeafCollector = Objects.requireNonNull(builder.buildLeafCollector, "build_leaf_collector");
        this.buildLeafCollectorCount = Objects.requireNonNull(builder.buildLeafCollectorCount, "build_leaf_collector_count");
        this.collect = Objects.requireNonNull(builder.collect, "collect");
        this.collectCount = Objects.requireNonNull(builder.collectCount, "collect_count");
        this.initialize = Objects.requireNonNull(builder.initialize, "initialize");
        this.initializeCount = Objects.requireNonNull(builder.initializeCount, "initialize_count");
        this.postCollection = builder.postCollection;
        this.postCollectionCount = builder.postCollectionCount;
        this.reduce = Objects.requireNonNull(builder.reduce, "reduce");
        this.reduceCount = Objects.requireNonNull(builder.reduceCount, "reduce_count");
    }

    public AggregationBreakdown(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long buildAggregation() {
        return this.buildAggregation;
    }

    public long buildAggregationCount() {
        return this.buildAggregationCount;
    }

    public long buildLeafCollector() {
        return this.buildLeafCollector;
    }

    public long buildLeafCollectorCount() {
        return this.buildLeafCollectorCount;
    }

    public long collect() {
        return this.collect;
    }

    public long collectCount() {
        return this.collectCount;
    }

    public long initialize() {
        return this.initialize;
    }

    public long initializeCount() {
        return this.initializeCount;
    }

    @Nullable
    public Long postCollection() {
        return this.postCollection;
    }

    @Nullable
    public Long postCollectionCount() {
        return this.postCollectionCount;
    }

    public long reduce() {
        return this.reduce;
    }

    public long reduceCount() {
        return this.reduceCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("build_aggregation");
        generator.write(this.buildAggregation);
        generator.writeKey("build_aggregation_count");
        generator.write(this.buildAggregationCount);
        generator.writeKey("build_leaf_collector");
        generator.write(this.buildLeafCollector);
        generator.writeKey("build_leaf_collector_count");
        generator.write(this.buildLeafCollectorCount);
        generator.writeKey("collect");
        generator.write(this.collect);
        generator.writeKey("collect_count");
        generator.write(this.collectCount);
        generator.writeKey("initialize");
        generator.write(this.initialize);
        generator.writeKey("initialize_count");
        generator.write(this.initializeCount);
        if (this.postCollection != null) {
            generator.writeKey("post_collection");
            generator.write(this.postCollection.longValue());
        }
        if (this.postCollectionCount != null) {
            generator.writeKey("post_collection_count");
            generator.write(this.postCollectionCount.longValue());
        }
        generator.writeKey("reduce");
        generator.write(this.reduce);
        generator.writeKey("reduce_count");
        generator.write(this.reduceCount);
    }

    protected static void setupAggregationBreakdownDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::buildAggregation, JsonpDeserializer.longDeserializer(), "build_aggregation", new String[0]);
        op.add(Builder::buildAggregationCount, JsonpDeserializer.longDeserializer(), "build_aggregation_count", new String[0]);
        op.add(Builder::buildLeafCollector, JsonpDeserializer.longDeserializer(), "build_leaf_collector", new String[0]);
        op.add(Builder::buildLeafCollectorCount, JsonpDeserializer.longDeserializer(), "build_leaf_collector_count", new String[0]);
        op.add(Builder::collect, JsonpDeserializer.longDeserializer(), "collect", new String[0]);
        op.add(Builder::collectCount, JsonpDeserializer.longDeserializer(), "collect_count", new String[0]);
        op.add(Builder::initialize, JsonpDeserializer.longDeserializer(), "initialize", new String[0]);
        op.add(Builder::initializeCount, JsonpDeserializer.longDeserializer(), "initialize_count", new String[0]);
        op.add(Builder::postCollection, JsonpDeserializer.longDeserializer(), "post_collection", new String[0]);
        op.add(Builder::postCollectionCount, JsonpDeserializer.longDeserializer(), "post_collection_count", new String[0]);
        op.add(Builder::reduce, JsonpDeserializer.longDeserializer(), "reduce", new String[0]);
        op.add(Builder::reduceCount, JsonpDeserializer.longDeserializer(), "reduce_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AggregationBreakdown> {
        private Long buildAggregation;
        private Long buildAggregationCount;
        private Long buildLeafCollector;
        private Long buildLeafCollectorCount;
        private Long collect;
        private Long collectCount;
        private Long initialize;
        private Long initializeCount;
        @Nullable
        private Long postCollection;
        @Nullable
        private Long postCollectionCount;
        private Long reduce;
        private Long reduceCount;

        public Builder buildAggregation(long value) {
            this.buildAggregation = value;
            return this;
        }

        public Builder buildAggregationCount(long value) {
            this.buildAggregationCount = value;
            return this;
        }

        public Builder buildLeafCollector(long value) {
            this.buildLeafCollector = value;
            return this;
        }

        public Builder buildLeafCollectorCount(long value) {
            this.buildLeafCollectorCount = value;
            return this;
        }

        public Builder collect(long value) {
            this.collect = value;
            return this;
        }

        public Builder collectCount(long value) {
            this.collectCount = value;
            return this;
        }

        public Builder initialize(long value) {
            this.initialize = value;
            return this;
        }

        public Builder initializeCount(long value) {
            this.initializeCount = value;
            return this;
        }

        public Builder postCollection(@Nullable Long value) {
            this.postCollection = value;
            return this;
        }

        public Builder postCollectionCount(@Nullable Long value) {
            this.postCollectionCount = value;
            return this;
        }

        public Builder reduce(long value) {
            this.reduce = value;
            return this;
        }

        public Builder reduceCount(long value) {
            this.reduceCount = value;
            return this;
        }

        @Override
        public AggregationBreakdown build() {
            return new AggregationBreakdown(this);
        }
    }
}

