/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.reindex_rethrottle;

import co.elastic.clients.elasticsearch.core.reindex_rethrottle.ReindexStatus;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ReindexTask
implements JsonpSerializable {
    private final String action;
    private final boolean cancellable;
    private final String description;
    private final long id;
    private final String node;
    private final long runningTimeInNanos;
    private final long startTimeInMillis;
    private final ReindexStatus status;
    private final String type;
    private final Map<String, List<String>> headers;
    public static final JsonpDeserializer<ReindexTask> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexTask::setupReindexTaskDeserializer, Builder::build);

    public ReindexTask(Builder builder) {
        this.action = Objects.requireNonNull(builder.action, "action");
        this.cancellable = Objects.requireNonNull(builder.cancellable, "cancellable");
        this.description = Objects.requireNonNull(builder.description, "description");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.node = Objects.requireNonNull(builder.node, "node");
        this.runningTimeInNanos = Objects.requireNonNull(builder.runningTimeInNanos, "running_time_in_nanos");
        this.startTimeInMillis = Objects.requireNonNull(builder.startTimeInMillis, "start_time_in_millis");
        this.status = Objects.requireNonNull(builder.status, "status");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.headers = ModelTypeHelper.unmodifiableNonNull(builder.headers, "headers");
    }

    public ReindexTask(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String action() {
        return this.action;
    }

    public boolean cancellable() {
        return this.cancellable;
    }

    public String description() {
        return this.description;
    }

    public long id() {
        return this.id;
    }

    public String node() {
        return this.node;
    }

    public long runningTimeInNanos() {
        return this.runningTimeInNanos;
    }

    public long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    public ReindexStatus status() {
        return this.status;
    }

    public String type() {
        return this.type;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("action");
        generator.write(this.action);
        generator.writeKey("cancellable");
        generator.write(this.cancellable);
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("running_time_in_nanos");
        generator.write(this.runningTimeInNanos);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("headers");
        generator.writeStartObject();
        for (Map.Entry<String, List<String>> item0 : this.headers.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.writeStartArray();
            for (String item1 : item0.getValue()) {
                generator.write(item1);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    protected static void setupReindexTaskDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::action, JsonpDeserializer.stringDeserializer(), "action", new String[0]);
        op.add(Builder::cancellable, JsonpDeserializer.booleanDeserializer(), "cancellable", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::id, JsonpDeserializer.longDeserializer(), "id", new String[0]);
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node", new String[0]);
        op.add(Builder::runningTimeInNanos, JsonpDeserializer.longDeserializer(), "running_time_in_nanos", new String[0]);
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis", new String[0]);
        op.add(Builder::status, ReindexStatus._DESERIALIZER, "status", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(Builder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "headers", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ReindexTask> {
        private String action;
        private Boolean cancellable;
        private String description;
        private Long id;
        private String node;
        private Long runningTimeInNanos;
        private Long startTimeInMillis;
        private ReindexStatus status;
        private String type;
        private Map<String, List<String>> headers;

        public Builder action(String value) {
            this.action = value;
            return this;
        }

        public Builder cancellable(boolean value) {
            this.cancellable = value;
            return this;
        }

        public Builder description(String value) {
            this.description = value;
            return this;
        }

        public Builder id(long value) {
            this.id = value;
            return this;
        }

        public Builder node(String value) {
            this.node = value;
            return this;
        }

        public Builder runningTimeInNanos(long value) {
            this.runningTimeInNanos = value;
            return this;
        }

        public Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public Builder status(ReindexStatus value) {
            this.status = value;
            return this;
        }

        public Builder status(Function<ReindexStatus.Builder, ObjectBuilder<ReindexStatus>> fn) {
            return this.status(fn.apply(new ReindexStatus.Builder()).build());
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder headers(Map<String, List<String>> value) {
            this.headers = value;
            return this;
        }

        public Builder putHeaders(String key, List<String> value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, List<String>>();
            }
            this.headers.put(key, value);
            return this;
        }

        @Override
        public ReindexTask build() {
            return new ReindexTask(this);
        }
    }
}

