/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.reindex_rethrottle;

import co.elastic.clients.elasticsearch._types.BaseNode;
import co.elastic.clients.elasticsearch.core.reindex_rethrottle.ReindexTask;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class ReindexNode
extends BaseNode {
    private final Map<String, ReindexTask> tasks;
    public static final JsonpDeserializer<ReindexNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexNode::setupReindexNodeDeserializer, Builder::build);

    public ReindexNode(Builder builder) {
        super(builder);
        this.tasks = ModelTypeHelper.unmodifiableNonNull(builder.tasks, "tasks");
    }

    public ReindexNode(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, ReindexTask> tasks() {
        return this.tasks;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("tasks");
        generator.writeStartObject();
        for (Map.Entry<String, ReindexTask> item0 : this.tasks.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupReindexNodeDeserializer(DelegatingDeserializer<Builder> op) {
        BaseNode.setupBaseNodeDeserializer(op);
        op.add(Builder::tasks, JsonpDeserializer.stringMapDeserializer(ReindexTask._DESERIALIZER), "tasks", new String[0]);
    }

    public static class Builder
    extends BaseNode.AbstractBuilder<Builder>
    implements ObjectBuilder<ReindexNode> {
        private Map<String, ReindexTask> tasks;

        public Builder tasks(Map<String, ReindexTask> value) {
            this.tasks = value;
            return this;
        }

        public Builder putTasks(String key, ReindexTask value) {
            if (this.tasks == null) {
                this.tasks = new HashMap<String, ReindexTask>();
            }
            this.tasks.put(key, value);
            return this;
        }

        public Builder tasks(String key, Function<ReindexTask.Builder, ObjectBuilder<ReindexTask>> fn) {
            return this.tasks(Collections.singletonMap(key, fn.apply(new ReindexTask.Builder()).build()));
        }

        public Builder putTasks(String key, Function<ReindexTask.Builder, ObjectBuilder<ReindexTask>> fn) {
            return this.putTasks(key, fn.apply(new ReindexTask.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ReindexNode build() {
            return new ReindexNode(this);
        }
    }
}

