/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.rank_eval;

import co.elastic.clients.elasticsearch.core.rank_eval.RankEvalHitItem;
import co.elastic.clients.elasticsearch.core.rank_eval.UnratedDocument;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RankEvalMetricDetail
implements JsonpSerializable {
    private final double metricScore;
    private final List<UnratedDocument> unratedDocs;
    private final List<RankEvalHitItem> hits;
    private final Map<String, Map<String, JsonData>> metricDetails;
    public static final JsonpDeserializer<RankEvalMetricDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalMetricDetail::setupRankEvalMetricDetailDeserializer, Builder::build);

    public RankEvalMetricDetail(Builder builder) {
        this.metricScore = Objects.requireNonNull(builder.metricScore, "metric_score");
        this.unratedDocs = ModelTypeHelper.unmodifiableNonNull(builder.unratedDocs, "unrated_docs");
        this.hits = ModelTypeHelper.unmodifiableNonNull(builder.hits, "hits");
        this.metricDetails = ModelTypeHelper.unmodifiableNonNull(builder.metricDetails, "metric_details");
    }

    public RankEvalMetricDetail(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public double metricScore() {
        return this.metricScore;
    }

    public List<UnratedDocument> unratedDocs() {
        return this.unratedDocs;
    }

    public List<RankEvalHitItem> hits() {
        return this.hits;
    }

    public Map<String, Map<String, JsonData>> metricDetails() {
        return this.metricDetails;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("metric_score");
        generator.write(this.metricScore);
        generator.writeKey("unrated_docs");
        generator.writeStartArray();
        for (UnratedDocument unratedDocument : this.unratedDocs) {
            unratedDocument.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("hits");
        generator.writeStartArray();
        for (RankEvalHitItem rankEvalHitItem : this.hits) {
            rankEvalHitItem.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("metric_details");
        generator.writeStartObject();
        for (Map.Entry entry : this.metricDetails.entrySet()) {
            generator.writeKey((String)entry.getKey());
            generator.writeStartObject();
            for (Map.Entry item1 : ((Map)entry.getValue()).entrySet()) {
                generator.writeKey((String)item1.getKey());
                ((JsonData)item1.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    protected static void setupRankEvalMetricDetailDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::metricScore, JsonpDeserializer.doubleDeserializer(), "metric_score", new String[0]);
        op.add(Builder::unratedDocs, JsonpDeserializer.arrayDeserializer(UnratedDocument._DESERIALIZER), "unrated_docs", new String[0]);
        op.add(Builder::hits, JsonpDeserializer.arrayDeserializer(RankEvalHitItem._DESERIALIZER), "hits", new String[0]);
        op.add(Builder::metricDetails, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER)), "metric_details", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RankEvalMetricDetail> {
        private Double metricScore;
        private List<UnratedDocument> unratedDocs;
        private List<RankEvalHitItem> hits;
        private Map<String, Map<String, JsonData>> metricDetails;

        public Builder metricScore(double value) {
            this.metricScore = value;
            return this;
        }

        public Builder unratedDocs(List<UnratedDocument> value) {
            this.unratedDocs = value;
            return this;
        }

        public Builder unratedDocs(UnratedDocument ... value) {
            this.unratedDocs = Arrays.asList(value);
            return this;
        }

        public Builder addUnratedDocs(UnratedDocument value) {
            if (this.unratedDocs == null) {
                this.unratedDocs = new ArrayList<UnratedDocument>();
            }
            this.unratedDocs.add(value);
            return this;
        }

        public Builder unratedDocs(Function<UnratedDocument.Builder, ObjectBuilder<UnratedDocument>> fn) {
            return this.unratedDocs(fn.apply(new UnratedDocument.Builder()).build());
        }

        public Builder addUnratedDocs(Function<UnratedDocument.Builder, ObjectBuilder<UnratedDocument>> fn) {
            return this.addUnratedDocs(fn.apply(new UnratedDocument.Builder()).build());
        }

        public Builder hits(List<RankEvalHitItem> value) {
            this.hits = value;
            return this;
        }

        public Builder hits(RankEvalHitItem ... value) {
            this.hits = Arrays.asList(value);
            return this;
        }

        public Builder addHits(RankEvalHitItem value) {
            if (this.hits == null) {
                this.hits = new ArrayList<RankEvalHitItem>();
            }
            this.hits.add(value);
            return this;
        }

        public Builder hits(Function<RankEvalHitItem.Builder, ObjectBuilder<RankEvalHitItem>> fn) {
            return this.hits(fn.apply(new RankEvalHitItem.Builder()).build());
        }

        public Builder addHits(Function<RankEvalHitItem.Builder, ObjectBuilder<RankEvalHitItem>> fn) {
            return this.addHits(fn.apply(new RankEvalHitItem.Builder()).build());
        }

        public Builder metricDetails(Map<String, Map<String, JsonData>> value) {
            this.metricDetails = value;
            return this;
        }

        public Builder putMetricDetails(String key, Map<String, JsonData> value) {
            if (this.metricDetails == null) {
                this.metricDetails = new HashMap<String, Map<String, JsonData>>();
            }
            this.metricDetails.put(key, value);
            return this;
        }

        @Override
        public RankEvalMetricDetail build() {
            return new RankEvalMetricDetail(this);
        }
    }
}

