/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.mtermvectors;

import co.elastic.clients.elasticsearch.core.termvectors.TermVector;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TermVectorsResult
implements JsonpSerializable {
    private final boolean found;
    private final String id;
    private final String index;
    private final Map<String, TermVector> termVectors;
    private final long took;
    private final long version;
    public static final JsonpDeserializer<TermVectorsResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermVectorsResult::setupTermVectorsResultDeserializer, Builder::build);

    public TermVectorsResult(Builder builder) {
        this.found = Objects.requireNonNull(builder.found, "found");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.index = Objects.requireNonNull(builder.index, "index");
        this.termVectors = ModelTypeHelper.unmodifiableNonNull(builder.termVectors, "term_vectors");
        this.took = Objects.requireNonNull(builder.took, "took");
        this.version = Objects.requireNonNull(builder.version, "version");
    }

    public TermVectorsResult(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean found() {
        return this.found;
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    public Map<String, TermVector> termVectors() {
        return this.termVectors;
    }

    public long took() {
        return this.took;
    }

    public long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("found");
        generator.write(this.found);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("term_vectors");
        generator.writeStartObject();
        for (Map.Entry<String, TermVector> item0 : this.termVectors.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupTermVectorsResultDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::termVectors, JsonpDeserializer.stringMapDeserializer(TermVector._DESERIALIZER), "term_vectors", new String[0]);
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TermVectorsResult> {
        private Boolean found;
        private String id;
        private String index;
        private Map<String, TermVector> termVectors;
        private Long took;
        private Long version;

        public Builder found(boolean value) {
            this.found = value;
            return this;
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder termVectors(Map<String, TermVector> value) {
            this.termVectors = value;
            return this;
        }

        public Builder putTermVectors(String key, TermVector value) {
            if (this.termVectors == null) {
                this.termVectors = new HashMap<String, TermVector>();
            }
            this.termVectors.put(key, value);
            return this;
        }

        public Builder termVectors(String key, Function<TermVector.Builder, ObjectBuilder<TermVector>> fn) {
            return this.termVectors(Collections.singletonMap(key, fn.apply(new TermVector.Builder()).build()));
        }

        public Builder putTermVectors(String key, Function<TermVector.Builder, ObjectBuilder<TermVector>> fn) {
            return this.putTermVectors(key, fn.apply(new TermVector.Builder()).build());
        }

        public Builder took(long value) {
            this.took = value;
            return this;
        }

        public Builder version(long value) {
            this.version = value;
            return this;
        }

        @Override
        public TermVectorsResult build() {
            return new TermVectorsResult(this);
        }
    }
}

