/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.bulk;

import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class OperationBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final String index;
    @Nullable
    private final Integer retryOnConflict;
    @Nullable
    private final String routing;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;

    public OperationBase(AbstractBuilder<?> builder) {
        this.id = ((AbstractBuilder)builder).id;
        this.index = ((AbstractBuilder)builder).index;
        this.retryOnConflict = ((AbstractBuilder)builder).retryOnConflict;
        this.routing = ((AbstractBuilder)builder).routing;
        this.version = ((AbstractBuilder)builder).version;
        this.versionType = ((AbstractBuilder)builder).versionType;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public Integer retryOnConflict() {
        return this.retryOnConflict;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("_id");
            generator.write(this.id);
        }
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
        if (this.retryOnConflict != null) {
            generator.writeKey("retry_on_conflict");
            generator.write(this.retryOnConflict.intValue());
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupOperationBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(AbstractBuilder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(AbstractBuilder::retryOnConflict, JsonpDeserializer.integerDeserializer(), "retry_on_conflict", new String[0]);
        op.add(AbstractBuilder::routing, JsonpDeserializer.stringDeserializer(), "routing", new String[0]);
        op.add(AbstractBuilder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(AbstractBuilder::versionType, VersionType._DESERIALIZER, "version_type", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private String id;
        @Nullable
        private String index;
        @Nullable
        private Integer retryOnConflict;
        @Nullable
        private String routing;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        protected AbstractBuilder() {
        }

        public BuilderT id(@Nullable String value) {
            this.id = value;
            return this.self();
        }

        public BuilderT index(@Nullable String value) {
            this.index = value;
            return this.self();
        }

        public BuilderT retryOnConflict(@Nullable Integer value) {
            this.retryOnConflict = value;
            return this.self();
        }

        public BuilderT routing(@Nullable String value) {
            this.routing = value;
            return this.self();
        }

        public BuilderT version(@Nullable Long value) {
            this.version = value;
            return this.self();
        }

        public BuilderT versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

