/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.InlineGet;
import co.elastic.clients.elasticsearch._types.WriteResponseBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class UpdateResponse<TDocument>
extends WriteResponseBase {
    @Nullable
    private final InlineGet<TDocument> get;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public UpdateResponse(Builder<TDocument> builder) {
        super(builder);
        this.get = ((Builder)builder).get;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public UpdateResponse(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public InlineGet<TDocument> get() {
        return this.get;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.get != null) {
            generator.writeKey("get");
            this.get.serialize(generator, mapper);
        }
    }

    public static <TDocument> JsonpDeserializer<UpdateResponse<TDocument>> createUpdateResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> UpdateResponse.setupUpdateResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupUpdateResponseDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        WriteResponseBase.setupWriteResponseBaseDeserializer(op);
        op.add(Builder::get, InlineGet.createInlineGetDeserializer(tDocumentDeserializer), "get", new String[0]);
    }

    public static class Builder<TDocument>
    extends WriteResponseBase.AbstractBuilder<Builder<TDocument>>
    implements ObjectBuilder<UpdateResponse<TDocument>> {
        @Nullable
        private InlineGet<TDocument> get;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> get(@Nullable InlineGet<TDocument> value) {
            this.get = value;
            return this;
        }

        public Builder<TDocument> get(Function<InlineGet.Builder<TDocument>, ObjectBuilder<InlineGet<TDocument>>> fn) {
            return this.get(fn.apply(new InlineGet.Builder()).build());
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public UpdateResponse<TDocument> build() {
            return new UpdateResponse(this);
        }
    }
}

