/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class UpdateRequest<TDocument, TPartialDocument>
extends RequestBase
implements JsonpSerializable {
    private final String id;
    private final String index;
    @Nullable
    private final String type;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Integer ifSeqNo;
    @Nullable
    private final String lang;
    @Nullable
    private final JsonValue refresh;
    @Nullable
    private final Boolean requireAlias;
    @Nullable
    private final Long retryOnConflict;
    @Nullable
    private final String routing;
    @Nullable
    private final String timeout;
    @Nullable
    private final JsonValue waitForActiveShards;
    @Nullable
    private final List<String> sourceExcludes;
    @Nullable
    private final List<String> sourceIncludes;
    @Nullable
    private final Boolean detectNoop;
    @Nullable
    private final TPartialDocument doc;
    @Nullable
    private final Boolean docAsUpsert;
    @Nullable
    private final JsonValue script;
    @Nullable
    private final Boolean scriptedUpsert;
    @Nullable
    private final JsonValue source;
    @Nullable
    private final TDocument upsert;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    @Nullable
    private final JsonpSerializer<TPartialDocument> tPartialDocumentSerializer;
    private static final SimpleEndpoint<UpdateRequest<?, ?>, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> {
        boolean _id = true;
        int _index = 2;
        int _type = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if (request.type() != null) {
            propsSet |= 4;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_update");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(request.ifPrimaryTerm));
        }
        if (request.ifSeqNo != null) {
            params.put("if_seq_no", String.valueOf(request.ifSeqNo));
        }
        if (request.lang != null) {
            params.put("lang", request.lang);
        }
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        if (request.requireAlias != null) {
            params.put("require_alias", String.valueOf(request.requireAlias));
        }
        if (request.retryOnConflict != null) {
            params.put("retry_on_conflict", String.valueOf(request.retryOnConflict));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", JsonpUtils.toString(request.waitForActiveShards));
        }
        if (request.sourceExcludes != null) {
            params.put("_source_excludes", request.sourceExcludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.sourceIncludes != null) {
            params.put("_source_includes", request.sourceIncludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    public UpdateRequest(Builder<TDocument, TPartialDocument> builder) {
        this.id = Objects.requireNonNull(((Builder)builder).id, "id");
        this.index = Objects.requireNonNull(((Builder)builder).index, "index");
        this.type = ((Builder)builder).type;
        this.ifPrimaryTerm = ((Builder)builder).ifPrimaryTerm;
        this.ifSeqNo = ((Builder)builder).ifSeqNo;
        this.lang = ((Builder)builder).lang;
        this.refresh = ((Builder)builder).refresh;
        this.requireAlias = ((Builder)builder).requireAlias;
        this.retryOnConflict = ((Builder)builder).retryOnConflict;
        this.routing = ((Builder)builder).routing;
        this.timeout = ((Builder)builder).timeout;
        this.waitForActiveShards = ((Builder)builder).waitForActiveShards;
        this.sourceExcludes = ModelTypeHelper.unmodifiable(((Builder)builder).sourceExcludes);
        this.sourceIncludes = ModelTypeHelper.unmodifiable(((Builder)builder).sourceIncludes);
        this.detectNoop = ((Builder)builder).detectNoop;
        this.doc = ((Builder)builder).doc;
        this.docAsUpsert = ((Builder)builder).docAsUpsert;
        this.script = ((Builder)builder).script;
        this.scriptedUpsert = ((Builder)builder).scriptedUpsert;
        this.source = ((Builder)builder).source;
        this.upsert = ((Builder)builder).upsert;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
        this.tPartialDocumentSerializer = ((Builder)builder).tPartialDocumentSerializer;
    }

    public UpdateRequest(Function<Builder<TDocument, TPartialDocument>, Builder<TDocument, TPartialDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public Integer ifSeqNo() {
        return this.ifSeqNo;
    }

    @Nullable
    public String lang() {
        return this.lang;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    @Nullable
    public Boolean requireAlias() {
        return this.requireAlias;
    }

    @Nullable
    public Long retryOnConflict() {
        return this.retryOnConflict;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public JsonValue waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    @Nullable
    public List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    @Nullable
    public Boolean detectNoop() {
        return this.detectNoop;
    }

    @Nullable
    public TPartialDocument doc() {
        return this.doc;
    }

    @Nullable
    public Boolean docAsUpsert() {
        return this.docAsUpsert;
    }

    @Nullable
    public JsonValue script() {
        return this.script;
    }

    @Nullable
    public Boolean scriptedUpsert() {
        return this.scriptedUpsert;
    }

    @Nullable
    public JsonValue source() {
        return this.source;
    }

    @Nullable
    public TDocument upsert() {
        return this.upsert;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.detectNoop != null) {
            generator.writeKey("detect_noop");
            generator.write(this.detectNoop.booleanValue());
        }
        if (this.doc != null) {
            generator.writeKey("doc");
            JsonpUtils.serialize(this.doc, generator, this.tPartialDocumentSerializer, mapper);
        }
        if (this.docAsUpsert != null) {
            generator.writeKey("doc_as_upsert");
            generator.write(this.docAsUpsert.booleanValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.scriptedUpsert != null) {
            generator.writeKey("scripted_upsert");
            generator.write(this.scriptedUpsert.booleanValue());
        }
        if (this.source != null) {
            generator.writeKey("_source");
            generator.write(this.source);
        }
        if (this.upsert != null) {
            generator.writeKey("upsert");
            JsonpUtils.serialize(this.upsert, generator, this.tDocumentSerializer, mapper);
        }
    }

    public static <TDocument, TPartialDocument> JsonpDeserializer<UpdateRequest<TDocument, TPartialDocument>> createUpdateRequestDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer, JsonpDeserializer<TPartialDocument> tPartialDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> UpdateRequest.setupUpdateRequestDeserializer(op, tDocumentDeserializer, tPartialDocumentDeserializer));
    }

    protected static <TDocument, TPartialDocument> void setupUpdateRequestDeserializer(DelegatingDeserializer<Builder<TDocument, TPartialDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer, JsonpDeserializer<TPartialDocument> tPartialDocumentDeserializer) {
        op.add(Builder::detectNoop, JsonpDeserializer.booleanDeserializer(), "detect_noop", new String[0]);
        op.add(Builder::doc, tPartialDocumentDeserializer, "doc", new String[0]);
        op.add(Builder::docAsUpsert, JsonpDeserializer.booleanDeserializer(), "doc_as_upsert", new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
        op.add(Builder::scriptedUpsert, JsonpDeserializer.booleanDeserializer(), "scripted_upsert", new String[0]);
        op.add(Builder::source, JsonpDeserializer.jsonValueDeserializer(), "_source", new String[0]);
        op.add(Builder::upsert, tDocumentDeserializer, "upsert", new String[0]);
    }

    public static <TDocument> Endpoint<UpdateRequest<?, ?>, UpdateResponse<TDocument>, ElasticsearchError> createUpdateEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(UpdateResponse.createUpdateResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder<TDocument, TPartialDocument>
    implements ObjectBuilder<UpdateRequest<TDocument, TPartialDocument>> {
        private String id;
        private String index;
        @Nullable
        private String type;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Integer ifSeqNo;
        @Nullable
        private String lang;
        @Nullable
        private JsonValue refresh;
        @Nullable
        private Boolean requireAlias;
        @Nullable
        private Long retryOnConflict;
        @Nullable
        private String routing;
        @Nullable
        private String timeout;
        @Nullable
        private JsonValue waitForActiveShards;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private Boolean detectNoop;
        @Nullable
        private TPartialDocument doc;
        @Nullable
        private Boolean docAsUpsert;
        @Nullable
        private JsonValue script;
        @Nullable
        private Boolean scriptedUpsert;
        @Nullable
        private JsonValue source;
        @Nullable
        private TDocument upsert;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;
        @Nullable
        private JsonpSerializer<TPartialDocument> tPartialDocumentSerializer;

        public Builder<TDocument, TPartialDocument> id(String value) {
            this.id = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> index(String value) {
            this.index = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> ifSeqNo(@Nullable Integer value) {
            this.ifSeqNo = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> lang(@Nullable String value) {
            this.lang = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> retryOnConflict(@Nullable Long value) {
            this.retryOnConflict = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> waitForActiveShards(@Nullable JsonValue value) {
            this.waitForActiveShards = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> sourceExcludes(@Nullable List<String> value) {
            this.sourceExcludes = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> sourceExcludes(String ... value) {
            this.sourceExcludes = Arrays.asList(value);
            return this;
        }

        public Builder<TDocument, TPartialDocument> addSourceExcludes(String value) {
            if (this.sourceExcludes == null) {
                this.sourceExcludes = new ArrayList<String>();
            }
            this.sourceExcludes.add(value);
            return this;
        }

        public Builder<TDocument, TPartialDocument> sourceIncludes(@Nullable List<String> value) {
            this.sourceIncludes = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> sourceIncludes(String ... value) {
            this.sourceIncludes = Arrays.asList(value);
            return this;
        }

        public Builder<TDocument, TPartialDocument> addSourceIncludes(String value) {
            if (this.sourceIncludes == null) {
                this.sourceIncludes = new ArrayList<String>();
            }
            this.sourceIncludes.add(value);
            return this;
        }

        public Builder<TDocument, TPartialDocument> detectNoop(@Nullable Boolean value) {
            this.detectNoop = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> doc(@Nullable TPartialDocument value) {
            this.doc = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> docAsUpsert(@Nullable Boolean value) {
            this.docAsUpsert = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> script(@Nullable JsonValue value) {
            this.script = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> scriptedUpsert(@Nullable Boolean value) {
            this.scriptedUpsert = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> source(@Nullable JsonValue value) {
            this.source = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> upsert(@Nullable TDocument value) {
            this.upsert = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        public Builder<TDocument, TPartialDocument> tPartialDocumentSerializer(@Nullable JsonpSerializer<TPartialDocument> value) {
            this.tPartialDocumentSerializer = value;
            return this;
        }

        @Override
        public UpdateRequest<TDocument, TPartialDocument> build() {
            return new UpdateRequest(this);
        }
    }
}

