/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch.core.termvectors.TermVector;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TermvectorsResponse
implements JsonpSerializable {
    private final boolean found;
    private final String id;
    private final String index;
    @Nullable
    private final Map<String, TermVector> termVectors;
    private final long took;
    @Nullable
    private final String type;
    private final long version;
    public static final JsonpDeserializer<TermvectorsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermvectorsResponse::setupTermvectorsResponseDeserializer, Builder::build);

    public TermvectorsResponse(Builder builder) {
        this.found = Objects.requireNonNull(builder.found, "found");
        this.id = Objects.requireNonNull(builder.id, "_id");
        this.index = Objects.requireNonNull(builder.index, "_index");
        this.termVectors = ModelTypeHelper.unmodifiable(builder.termVectors);
        this.took = Objects.requireNonNull(builder.took, "took");
        this.type = builder.type;
        this.version = Objects.requireNonNull(builder.version, "_version");
    }

    public TermvectorsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean found() {
        return this.found;
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public Map<String, TermVector> termVectors() {
        return this.termVectors;
    }

    public long took() {
        return this.took;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    public long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("found");
        generator.write(this.found);
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        if (this.termVectors != null) {
            generator.writeKey("term_vectors");
            generator.writeStartObject();
            for (Map.Entry<String, TermVector> item0 : this.termVectors.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("took");
        generator.write(this.took);
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
        generator.writeKey("_version");
        generator.write(this.version);
    }

    protected static void setupTermvectorsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(Builder::termVectors, JsonpDeserializer.stringMapDeserializer(TermVector._DESERIALIZER), "term_vectors", new String[0]);
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TermvectorsResponse> {
        private Boolean found;
        private String id;
        private String index;
        @Nullable
        private Map<String, TermVector> termVectors;
        private Long took;
        @Nullable
        private String type;
        private Long version;

        public Builder found(boolean value) {
            this.found = value;
            return this;
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder termVectors(@Nullable Map<String, TermVector> value) {
            this.termVectors = value;
            return this;
        }

        public Builder putTermVectors(String key, TermVector value) {
            if (this.termVectors == null) {
                this.termVectors = new HashMap<String, TermVector>();
            }
            this.termVectors.put(key, value);
            return this;
        }

        public Builder termVectors(String key, Function<TermVector.Builder, ObjectBuilder<TermVector>> fn) {
            return this.termVectors(Collections.singletonMap(key, fn.apply(new TermVector.Builder()).build()));
        }

        public Builder putTermVectors(String key, Function<TermVector.Builder, ObjectBuilder<TermVector>> fn) {
            return this.putTermVectors(key, fn.apply(new TermVector.Builder()).build());
        }

        public Builder took(long value) {
            this.took = value;
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder version(long value) {
            this.version = value;
            return this;
        }

        @Override
        public TermvectorsResponse build() {
            return new TermvectorsResponse(this);
        }
    }
}

