/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch.core.TermvectorsResponse;
import co.elastic.clients.elasticsearch.core.termvectors.Filter;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class TermvectorsRequest<TDocument>
extends RequestBase
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final String id;
    @Nullable
    private final String type;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final Boolean fieldStatistics;
    @Nullable
    private final Boolean offsets;
    @Nullable
    private final Boolean payloads;
    @Nullable
    private final Boolean positions;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean realtime;
    @Nullable
    private final String routing;
    @Nullable
    private final Boolean termStatistics;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    @Nullable
    private final TDocument doc;
    @Nullable
    private final Filter filter;
    @Nullable
    private final Map<String, String> perFieldAnalyzer;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final Endpoint<TermvectorsRequest<?>, TermvectorsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<TermvectorsRequest, TermvectorsResponse>(request -> "POST", request -> {
        boolean _index = true;
        int _id = 2;
        int _type = 4;
        int propsSet = 0;
        propsSet |= 1;
        if (request.id() != null) {
            propsSet |= 2;
        }
        if (request.type() != null) {
            propsSet |= 4;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_termvectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_termvectors");
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_termvectors");
            return buf.toString();
        }
        if (propsSet == 5) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/_termvectors");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.fields != null) {
            params.put("fields", request.fields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.fieldStatistics != null) {
            params.put("field_statistics", String.valueOf(request.fieldStatistics));
        }
        if (request.offsets != null) {
            params.put("offsets", String.valueOf(request.offsets));
        }
        if (request.payloads != null) {
            params.put("payloads", String.valueOf(request.payloads));
        }
        if (request.positions != null) {
            params.put("positions", String.valueOf(request.positions));
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.realtime != null) {
            params.put("realtime", String.valueOf(request.realtime));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.termStatistics != null) {
            params.put("term_statistics", String.valueOf(request.termStatistics));
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.toString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, TermvectorsResponse._DESERIALIZER);

    public TermvectorsRequest(Builder<TDocument> builder) {
        this.index = Objects.requireNonNull(((Builder)builder).index, "index");
        this.id = ((Builder)builder).id;
        this.type = ((Builder)builder).type;
        this.fields = ModelTypeHelper.unmodifiable(((Builder)builder).fields);
        this.fieldStatistics = ((Builder)builder).fieldStatistics;
        this.offsets = ((Builder)builder).offsets;
        this.payloads = ((Builder)builder).payloads;
        this.positions = ((Builder)builder).positions;
        this.preference = ((Builder)builder).preference;
        this.realtime = ((Builder)builder).realtime;
        this.routing = ((Builder)builder).routing;
        this.termStatistics = ((Builder)builder).termStatistics;
        this.version = ((Builder)builder).version;
        this.versionType = ((Builder)builder).versionType;
        this.doc = ((Builder)builder).doc;
        this.filter = ((Builder)builder).filter;
        this.perFieldAnalyzer = ModelTypeHelper.unmodifiable(((Builder)builder).perFieldAnalyzer);
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public TermvectorsRequest(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public Boolean fieldStatistics() {
        return this.fieldStatistics;
    }

    @Nullable
    public Boolean offsets() {
        return this.offsets;
    }

    @Nullable
    public Boolean payloads() {
        return this.payloads;
    }

    @Nullable
    public Boolean positions() {
        return this.positions;
    }

    @Nullable
    public String preference() {
        return this.preference;
    }

    @Nullable
    public Boolean realtime() {
        return this.realtime;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public Boolean termStatistics() {
        return this.termStatistics;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public VersionType versionType() {
        return this.versionType;
    }

    @Nullable
    public TDocument doc() {
        return this.doc;
    }

    @Nullable
    public Filter filter() {
        return this.filter;
    }

    @Nullable
    public Map<String, String> perFieldAnalyzer() {
        return this.perFieldAnalyzer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doc != null) {
            generator.writeKey("doc");
            JsonpUtils.serialize(this.doc, generator, this.tDocumentSerializer, mapper);
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.perFieldAnalyzer != null) {
            generator.writeKey("per_field_analyzer");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.perFieldAnalyzer.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    public static <TDocument> JsonpDeserializer<TermvectorsRequest<TDocument>> createTermvectorsRequestDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> TermvectorsRequest.setupTermvectorsRequestDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupTermvectorsRequestDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::doc, tDocumentDeserializer, "doc", new String[0]);
        op.add(Builder::filter, Filter._DESERIALIZER, "filter", new String[0]);
        op.add(Builder::perFieldAnalyzer, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "per_field_analyzer", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<TermvectorsRequest<TDocument>> {
        private String index;
        @Nullable
        private String id;
        @Nullable
        private String type;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean fieldStatistics;
        @Nullable
        private Boolean offsets;
        @Nullable
        private Boolean payloads;
        @Nullable
        private Boolean positions;
        @Nullable
        private String preference;
        @Nullable
        private Boolean realtime;
        @Nullable
        private String routing;
        @Nullable
        private Boolean termStatistics;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;
        @Nullable
        private TDocument doc;
        @Nullable
        private Filter filter;
        @Nullable
        private Map<String, String> perFieldAnalyzer;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public Builder<TDocument> id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder<TDocument> type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder<TDocument> fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder<TDocument> fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder<TDocument> addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder<TDocument> fieldStatistics(@Nullable Boolean value) {
            this.fieldStatistics = value;
            return this;
        }

        public Builder<TDocument> offsets(@Nullable Boolean value) {
            this.offsets = value;
            return this;
        }

        public Builder<TDocument> payloads(@Nullable Boolean value) {
            this.payloads = value;
            return this;
        }

        public Builder<TDocument> positions(@Nullable Boolean value) {
            this.positions = value;
            return this;
        }

        public Builder<TDocument> preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public Builder<TDocument> realtime(@Nullable Boolean value) {
            this.realtime = value;
            return this;
        }

        public Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder<TDocument> termStatistics(@Nullable Boolean value) {
            this.termStatistics = value;
            return this;
        }

        public Builder<TDocument> version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder<TDocument> versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        public Builder<TDocument> doc(@Nullable TDocument value) {
            this.doc = value;
            return this;
        }

        public Builder<TDocument> filter(@Nullable Filter value) {
            this.filter = value;
            return this;
        }

        public Builder<TDocument> filter(Function<Filter.Builder, ObjectBuilder<Filter>> fn) {
            return this.filter(fn.apply(new Filter.Builder()).build());
        }

        public Builder<TDocument> perFieldAnalyzer(@Nullable Map<String, String> value) {
            this.perFieldAnalyzer = value;
            return this;
        }

        public Builder<TDocument> putPerFieldAnalyzer(String key, String value) {
            if (this.perFieldAnalyzer == null) {
                this.perFieldAnalyzer = new HashMap<String, String>();
            }
            this.perFieldAnalyzer.put(key, value);
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public TermvectorsRequest<TDocument> build() {
            return new TermvectorsRequest(this);
        }
    }
}

