/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TermsEnumResponse
implements JsonpSerializable {
    private final ShardStatistics shards;
    private final List<String> terms;
    private final boolean complete;
    public static final JsonpDeserializer<TermsEnumResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsEnumResponse::setupTermsEnumResponseDeserializer, Builder::build);

    public TermsEnumResponse(Builder builder) {
        this.shards = Objects.requireNonNull(builder.shards, "_shards");
        this.terms = ModelTypeHelper.unmodifiableNonNull(builder.terms, "terms");
        this.complete = Objects.requireNonNull(builder.complete, "complete");
    }

    public TermsEnumResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    public List<String> terms() {
        return this.terms;
    }

    public boolean complete() {
        return this.complete;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("terms");
        generator.writeStartArray();
        for (String item0 : this.terms) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("complete");
        generator.write(this.complete);
    }

    protected static void setupTermsEnumResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
        op.add(Builder::terms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "terms", new String[0]);
        op.add(Builder::complete, JsonpDeserializer.booleanDeserializer(), "complete", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TermsEnumResponse> {
        private ShardStatistics shards;
        private List<String> terms;
        private Boolean complete;

        public Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public Builder terms(List<String> value) {
            this.terms = value;
            return this;
        }

        public Builder terms(String ... value) {
            this.terms = Arrays.asList(value);
            return this;
        }

        public Builder addTerms(String value) {
            if (this.terms == null) {
                this.terms = new ArrayList<String>();
            }
            this.terms.add(value);
            return this;
        }

        public Builder complete(boolean value) {
            this.complete = value;
            return this;
        }

        @Override
        public TermsEnumResponse build() {
            return new TermsEnumResponse(this);
        }
    }
}

