/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class SearchTemplateResponse<TDocument>
implements JsonpSerializable {
    private final ShardStatistics shards;
    private final boolean timedOut;
    private final int took;
    private final HitsMetadata<TDocument> hits;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public SearchTemplateResponse(Builder<TDocument> builder) {
        this.shards = Objects.requireNonNull(((Builder)builder).shards, "_shards");
        this.timedOut = Objects.requireNonNull(((Builder)builder).timedOut, "timed_out");
        this.took = Objects.requireNonNull(((Builder)builder).took, "took");
        this.hits = Objects.requireNonNull(((Builder)builder).hits, "hits");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public SearchTemplateResponse(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    public int took() {
        return this.took;
    }

    public HitsMetadata<TDocument> hits() {
        return this.hits;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
    }

    public static <TDocument> JsonpDeserializer<SearchTemplateResponse<TDocument>> createSearchTemplateResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> SearchTemplateResponse.setupSearchTemplateResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupSearchTemplateResponseDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out", new String[0]);
        op.add(Builder::took, JsonpDeserializer.integerDeserializer(), "took", new String[0]);
        op.add(Builder::hits, HitsMetadata.createHitsMetadataDeserializer(tDocumentDeserializer), "hits", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<SearchTemplateResponse<TDocument>> {
        private ShardStatistics shards;
        private Boolean timedOut;
        private Integer took;
        private HitsMetadata<TDocument> hits;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder<TDocument> shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public Builder<TDocument> timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public Builder<TDocument> took(int value) {
            this.took = value;
            return this;
        }

        public Builder<TDocument> hits(HitsMetadata<TDocument> value) {
            this.hits = value;
            return this;
        }

        public Builder<TDocument> hits(Function<HitsMetadata.Builder<TDocument>, ObjectBuilder<HitsMetadata<TDocument>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public SearchTemplateResponse<TDocument> build() {
            return new SearchTemplateResponse(this);
        }
    }
}

