/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch.core.SearchTemplateResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SearchTemplateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final List<String> index;
    @Nullable
    private final List<String> type;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean ccsMinimizeRoundtrips;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean ignoreThrottled;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final String preference;
    @Nullable
    private final String routing;
    @Nullable
    private final String scroll;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final Boolean typedKeys;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final String id;
    @Nullable
    private final Map<String, JsonData> params;
    @Nullable
    private final Boolean profile;
    @Nullable
    private final String source;
    public static final JsonpDeserializer<SearchTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchTemplateRequest::setupSearchTemplateRequestDeserializer, Builder::build);
    private static final SimpleEndpoint<SearchTemplateRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        if (request.index() != null) {
            propsSet |= 1;
        }
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_search");
            buf.append("/template");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_search");
            buf.append("/template");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_search");
            buf.append("/template");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.ccsMinimizeRoundtrips != null) {
            params.put("ccs_minimize_roundtrips", String.valueOf(request.ccsMinimizeRoundtrips));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.ignoreThrottled != null) {
            params.put("ignore_throttled", String.valueOf(request.ignoreThrottled));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.scroll != null) {
            params.put("scroll", request.scroll);
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType.toString());
        }
        if (request.typedKeys != null) {
            params.put("typed_keys", String.valueOf(request.typedKeys));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    public SearchTemplateRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.type = ModelTypeHelper.unmodifiable(builder.type);
        this.allowNoIndices = builder.allowNoIndices;
        this.ccsMinimizeRoundtrips = builder.ccsMinimizeRoundtrips;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreThrottled = builder.ignoreThrottled;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.preference = builder.preference;
        this.routing = builder.routing;
        this.scroll = builder.scroll;
        this.searchType = builder.searchType;
        this.typedKeys = builder.typedKeys;
        this.explain = builder.explain;
        this.id = builder.id;
        this.params = ModelTypeHelper.unmodifiable(builder.params);
        this.profile = builder.profile;
        this.source = builder.source;
    }

    public SearchTemplateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public List<String> type() {
        return this.type;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public Boolean ccsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public String preference() {
        return this.preference;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public String scroll() {
        return this.scroll;
    }

    @Nullable
    public SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public Boolean typedKeys() {
        return this.typedKeys;
    }

    @Nullable
    public Boolean explain() {
        return this.explain;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public Boolean profile() {
        return this.profile;
    }

    @Nullable
    public String source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.params != null) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            generator.write(this.profile.booleanValue());
        }
        if (this.source != null) {
            generator.writeKey("source");
            generator.write(this.source);
        }
    }

    protected static void setupSearchTemplateRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params", new String[0]);
        op.add(Builder::profile, JsonpDeserializer.booleanDeserializer(), "profile", new String[0]);
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source", new String[0]);
    }

    public static <TDocument> Endpoint<SearchTemplateRequest, SearchTemplateResponse<TDocument>, ElasticsearchError> createSearchTemplateEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(SearchTemplateResponse.createSearchTemplateResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<SearchTemplateRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private List<String> type;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean ccsMinimizeRoundtrips;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean ignoreThrottled;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private String preference;
        @Nullable
        private String routing;
        @Nullable
        private String scroll;
        @Nullable
        private SearchType searchType;
        @Nullable
        private Boolean typedKeys;
        @Nullable
        private Boolean explain;
        @Nullable
        private String id;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private Boolean profile;
        @Nullable
        private String source;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder type(@Nullable List<String> value) {
            this.type = value;
            return this;
        }

        public Builder type(String ... value) {
            this.type = Arrays.asList(value);
            return this;
        }

        public Builder addType(String value) {
            if (this.type == null) {
                this.type = new ArrayList<String>();
            }
            this.type.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder ccsMinimizeRoundtrips(@Nullable Boolean value) {
            this.ccsMinimizeRoundtrips = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder scroll(@Nullable String value) {
            this.scroll = value;
            return this;
        }

        public Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public Builder typedKeys(@Nullable Boolean value) {
            this.typedKeys = value;
            return this;
        }

        public Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder params(@Nullable Map<String, JsonData> value) {
            this.params = value;
            return this;
        }

        public Builder putParams(String key, JsonData value) {
            if (this.params == null) {
                this.params = new HashMap<String, JsonData>();
            }
            this.params.put(key, value);
            return this;
        }

        public Builder profile(@Nullable Boolean value) {
            this.profile = value;
            return this;
        }

        public Builder source(@Nullable String value) {
            this.source = value;
            return this;
        }

        @Override
        public SearchTemplateRequest build() {
            return new SearchTemplateRequest(this);
        }
    }
}

