/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.DefaultOperator;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SlicedScroll;
import co.elastic.clients.elasticsearch._types.SuggestMode;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.FieldCollapse;
import co.elastic.clients.elasticsearch.core.search.Highlight;
import co.elastic.clients.elasticsearch.core.search.PointInTimeReference;
import co.elastic.clients.elasticsearch.core.search.Rescore;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SearchRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final List<String> index;
    @Nullable
    private final List<String> type;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean allowPartialSearchResults;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final Long batchedReduceSize;
    @Nullable
    private final Boolean ccsMinimizeRoundtrips;
    @Nullable
    private final DefaultOperator defaultOperator;
    @Nullable
    private final String df;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean ignoreThrottled;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Long maxConcurrentShardRequests;
    @Nullable
    private final String minCompatibleShardNode;
    @Nullable
    private final String preference;
    @Nullable
    private final Long preFilterShardSize;
    @Nullable
    private final Boolean requestCache;
    @Nullable
    private final String routing;
    @Nullable
    private final String scroll;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final String suggestField;
    @Nullable
    private final SuggestMode suggestMode;
    @Nullable
    private final Long suggestSize;
    @Nullable
    private final String suggestText;
    @Nullable
    private final Boolean typedKeys;
    @Nullable
    private final List<String> sourceExcludes;
    @Nullable
    private final List<String> sourceIncludes;
    @Nullable
    private final String q;
    @Nullable
    private final Map<String, Aggregation> aggs;
    @Nullable
    private final Map<String, Aggregation> aggregations;
    @Nullable
    private final FieldCollapse collapse;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final Integer from;
    @Nullable
    private final Highlight highlight;
    @Nullable
    private final JsonValue trackTotalHits;
    @Nullable
    private final List<Map<String, Double>> indicesBoost;
    @Nullable
    private final JsonValue docvalueFields;
    @Nullable
    private final Double minScore;
    @Nullable
    private final Query postFilter;
    @Nullable
    private final Boolean profile;
    @Nullable
    private final Query query;
    @Nullable
    private final List<Rescore> rescore;
    @Nullable
    private final Map<String, ScriptField> scriptFields;
    @Nullable
    private final List<String> searchAfter;
    @Nullable
    private final Integer size;
    @Nullable
    private final SlicedScroll slice;
    @Nullable
    private final List<JsonValue> sort;
    @Nullable
    private final JsonValue source;
    @Nullable
    private final List<JsonValue> fields;
    @Nullable
    private final JsonValue suggest;
    @Nullable
    private final Long terminateAfter;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean trackScores;
    @Nullable
    private final Boolean version;
    @Nullable
    private final Boolean seqNoPrimaryTerm;
    @Nullable
    private final List<String> storedFields;
    @Nullable
    private final PointInTimeReference pit;
    @Nullable
    private final Map<String, RuntimeField> runtimeMappings;
    @Nullable
    private final List<String> stats;
    public static final JsonpDeserializer<SearchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchRequest::setupSearchRequestDeserializer, Builder::build);
    private static final SimpleEndpoint<SearchRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        if (request.index() != null) {
            propsSet |= 1;
        }
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_search");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_search");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_search");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.allowPartialSearchResults != null) {
            params.put("allow_partial_search_results", String.valueOf(request.allowPartialSearchResults));
        }
        if (request.analyzer != null) {
            params.put("analyzer", request.analyzer);
        }
        if (request.analyzeWildcard != null) {
            params.put("analyze_wildcard", String.valueOf(request.analyzeWildcard));
        }
        if (request.batchedReduceSize != null) {
            params.put("batched_reduce_size", String.valueOf(request.batchedReduceSize));
        }
        if (request.ccsMinimizeRoundtrips != null) {
            params.put("ccs_minimize_roundtrips", String.valueOf(request.ccsMinimizeRoundtrips));
        }
        if (request.defaultOperator != null) {
            params.put("default_operator", request.defaultOperator.toString());
        }
        if (request.df != null) {
            params.put("df", request.df);
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.ignoreThrottled != null) {
            params.put("ignore_throttled", String.valueOf(request.ignoreThrottled));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.lenient != null) {
            params.put("lenient", String.valueOf(request.lenient));
        }
        if (request.maxConcurrentShardRequests != null) {
            params.put("max_concurrent_shard_requests", String.valueOf(request.maxConcurrentShardRequests));
        }
        if (request.minCompatibleShardNode != null) {
            params.put("min_compatible_shard_node", request.minCompatibleShardNode);
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.preFilterShardSize != null) {
            params.put("pre_filter_shard_size", String.valueOf(request.preFilterShardSize));
        }
        if (request.requestCache != null) {
            params.put("request_cache", String.valueOf(request.requestCache));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.scroll != null) {
            params.put("scroll", request.scroll);
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType.toString());
        }
        if (request.suggestField != null) {
            params.put("suggest_field", request.suggestField);
        }
        if (request.suggestMode != null) {
            params.put("suggest_mode", request.suggestMode.toString());
        }
        if (request.suggestSize != null) {
            params.put("suggest_size", String.valueOf(request.suggestSize));
        }
        if (request.suggestText != null) {
            params.put("suggest_text", request.suggestText);
        }
        if (request.typedKeys != null) {
            params.put("typed_keys", String.valueOf(request.typedKeys));
        }
        if (request.sourceExcludes != null) {
            params.put("_source_excludes", request.sourceExcludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.sourceIncludes != null) {
            params.put("_source_includes", request.sourceIncludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.q != null) {
            params.put("q", request.q);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    public SearchRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.type = ModelTypeHelper.unmodifiable(builder.type);
        this.allowNoIndices = builder.allowNoIndices;
        this.allowPartialSearchResults = builder.allowPartialSearchResults;
        this.analyzer = builder.analyzer;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.batchedReduceSize = builder.batchedReduceSize;
        this.ccsMinimizeRoundtrips = builder.ccsMinimizeRoundtrips;
        this.defaultOperator = builder.defaultOperator;
        this.df = builder.df;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreThrottled = builder.ignoreThrottled;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.lenient = builder.lenient;
        this.maxConcurrentShardRequests = builder.maxConcurrentShardRequests;
        this.minCompatibleShardNode = builder.minCompatibleShardNode;
        this.preference = builder.preference;
        this.preFilterShardSize = builder.preFilterShardSize;
        this.requestCache = builder.requestCache;
        this.routing = builder.routing;
        this.scroll = builder.scroll;
        this.searchType = builder.searchType;
        this.suggestField = builder.suggestField;
        this.suggestMode = builder.suggestMode;
        this.suggestSize = builder.suggestSize;
        this.suggestText = builder.suggestText;
        this.typedKeys = builder.typedKeys;
        this.sourceExcludes = ModelTypeHelper.unmodifiable(builder.sourceExcludes);
        this.sourceIncludes = ModelTypeHelper.unmodifiable(builder.sourceIncludes);
        this.q = builder.q;
        this.aggs = ModelTypeHelper.unmodifiable(builder.aggs);
        this.aggregations = ModelTypeHelper.unmodifiable(builder.aggregations);
        this.collapse = builder.collapse;
        this.explain = builder.explain;
        this.from = builder.from;
        this.highlight = builder.highlight;
        this.trackTotalHits = builder.trackTotalHits;
        this.indicesBoost = ModelTypeHelper.unmodifiable(builder.indicesBoost);
        this.docvalueFields = builder.docvalueFields;
        this.minScore = builder.minScore;
        this.postFilter = builder.postFilter;
        this.profile = builder.profile;
        this.query = builder.query;
        this.rescore = ModelTypeHelper.unmodifiable(builder.rescore);
        this.scriptFields = ModelTypeHelper.unmodifiable(builder.scriptFields);
        this.searchAfter = ModelTypeHelper.unmodifiable(builder.searchAfter);
        this.size = builder.size;
        this.slice = builder.slice;
        this.sort = ModelTypeHelper.unmodifiable(builder.sort);
        this.source = builder.source;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.suggest = builder.suggest;
        this.terminateAfter = builder.terminateAfter;
        this.timeout = builder.timeout;
        this.trackScores = builder.trackScores;
        this.version = builder.version;
        this.seqNoPrimaryTerm = builder.seqNoPrimaryTerm;
        this.storedFields = ModelTypeHelper.unmodifiable(builder.storedFields);
        this.pit = builder.pit;
        this.runtimeMappings = ModelTypeHelper.unmodifiable(builder.runtimeMappings);
        this.stats = ModelTypeHelper.unmodifiable(builder.stats);
    }

    public SearchRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public List<String> type() {
        return this.type;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public Boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public Long batchedReduceSize() {
        return this.batchedReduceSize;
    }

    @Nullable
    public Boolean ccsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    @Nullable
    public DefaultOperator defaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public String df() {
        return this.df;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public Long maxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests;
    }

    @Nullable
    public String minCompatibleShardNode() {
        return this.minCompatibleShardNode;
    }

    @Nullable
    public String preference() {
        return this.preference;
    }

    @Nullable
    public Long preFilterShardSize() {
        return this.preFilterShardSize;
    }

    @Nullable
    public Boolean requestCache() {
        return this.requestCache;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public String scroll() {
        return this.scroll;
    }

    @Nullable
    public SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public String suggestField() {
        return this.suggestField;
    }

    @Nullable
    public SuggestMode suggestMode() {
        return this.suggestMode;
    }

    @Nullable
    public Long suggestSize() {
        return this.suggestSize;
    }

    @Nullable
    public String suggestText() {
        return this.suggestText;
    }

    @Nullable
    public Boolean typedKeys() {
        return this.typedKeys;
    }

    @Nullable
    public List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    @Nullable
    public List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    @Nullable
    public String q() {
        return this.q;
    }

    @Nullable
    public Map<String, Aggregation> aggs() {
        return this.aggs;
    }

    @Nullable
    public Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public FieldCollapse collapse() {
        return this.collapse;
    }

    @Nullable
    public Boolean explain() {
        return this.explain;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Highlight highlight() {
        return this.highlight;
    }

    @Nullable
    public JsonValue trackTotalHits() {
        return this.trackTotalHits;
    }

    @Nullable
    public List<Map<String, Double>> indicesBoost() {
        return this.indicesBoost;
    }

    @Nullable
    public JsonValue docvalueFields() {
        return this.docvalueFields;
    }

    @Nullable
    public Double minScore() {
        return this.minScore;
    }

    @Nullable
    public Query postFilter() {
        return this.postFilter;
    }

    @Nullable
    public Boolean profile() {
        return this.profile;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Nullable
    public List<Rescore> rescore() {
        return this.rescore;
    }

    @Nullable
    public Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    @Nullable
    public List<String> searchAfter() {
        return this.searchAfter;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public SlicedScroll slice() {
        return this.slice;
    }

    @Nullable
    public List<JsonValue> sort() {
        return this.sort;
    }

    @Nullable
    public JsonValue source() {
        return this.source;
    }

    @Nullable
    public List<JsonValue> fields() {
        return this.fields;
    }

    @Nullable
    public JsonValue suggest() {
        return this.suggest;
    }

    @Nullable
    public Long terminateAfter() {
        return this.terminateAfter;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean trackScores() {
        return this.trackScores;
    }

    @Nullable
    public Boolean version() {
        return this.version;
    }

    @Nullable
    public Boolean seqNoPrimaryTerm() {
        return this.seqNoPrimaryTerm;
    }

    @Nullable
    public List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public PointInTimeReference pit() {
        return this.pit;
    }

    @Nullable
    public Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Nullable
    public List<String> stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aggs != null) {
            generator.writeKey("aggs");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggs.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.aggregations != null) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.collapse != null) {
            generator.writeKey("collapse");
            this.collapse.serialize(generator, mapper);
        }
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.highlight != null) {
            generator.writeKey("highlight");
            this.highlight.serialize(generator, mapper);
        }
        if (this.trackTotalHits != null) {
            generator.writeKey("track_total_hits");
            generator.write(this.trackTotalHits);
        }
        if (this.indicesBoost != null) {
            generator.writeKey("indices_boost");
            generator.writeStartArray();
            for (Map map : this.indicesBoost) {
                generator.writeStartObject();
                for (Map.Entry item1 : map.entrySet()) {
                    generator.writeKey((String)item1.getKey());
                    generator.write(((Double)item1.getValue()).doubleValue());
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.docvalueFields != null) {
            generator.writeKey("docvalue_fields");
            generator.write(this.docvalueFields);
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write(this.minScore.doubleValue());
        }
        if (this.postFilter != null) {
            generator.writeKey("post_filter");
            this.postFilter.serialize(generator, mapper);
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            generator.write(this.profile.booleanValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.rescore != null) {
            generator.writeKey("rescore");
            generator.writeStartArray();
            for (Rescore rescore : this.rescore) {
                rescore.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.scriptFields != null) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.searchAfter != null) {
            generator.writeKey("search_after");
            generator.writeStartArray();
            for (String string : this.searchAfter) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.slice != null) {
            generator.writeKey("slice");
            this.slice.serialize(generator, mapper);
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.sort) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("_source");
            generator.write(this.source);
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.fields) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
        if (this.suggest != null) {
            generator.writeKey("suggest");
            generator.write(this.suggest);
        }
        if (this.terminateAfter != null) {
            generator.writeKey("terminate_after");
            generator.write(this.terminateAfter.longValue());
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            generator.write(this.timeout);
        }
        if (this.trackScores != null) {
            generator.writeKey("track_scores");
            generator.write(this.trackScores.booleanValue());
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.booleanValue());
        }
        if (this.seqNoPrimaryTerm != null) {
            generator.writeKey("seq_no_primary_term");
            generator.write(this.seqNoPrimaryTerm.booleanValue());
        }
        if (this.storedFields != null) {
            generator.writeKey("stored_fields");
            generator.writeStartArray();
            for (String string : this.storedFields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.pit != null) {
            generator.writeKey("pit");
            this.pit.serialize(generator, mapper);
        }
        if (this.runtimeMappings != null) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.stats != null) {
            generator.writeKey("stats");
            generator.writeStartArray();
            for (String string : this.stats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSearchRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggs, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggs", new String[0]);
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", new String[0]);
        op.add(Builder::collapse, FieldCollapse._DESERIALIZER, "collapse", new String[0]);
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain", new String[0]);
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from", new String[0]);
        op.add(Builder::highlight, Highlight._DESERIALIZER, "highlight", new String[0]);
        op.add(Builder::trackTotalHits, JsonpDeserializer.jsonValueDeserializer(), "track_total_hits", new String[0]);
        op.add(Builder::indicesBoost, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer())), "indices_boost", new String[0]);
        op.add(Builder::docvalueFields, JsonpDeserializer.jsonValueDeserializer(), "docvalue_fields", new String[0]);
        op.add(Builder::minScore, JsonpDeserializer.doubleDeserializer(), "min_score", new String[0]);
        op.add(Builder::postFilter, Query._DESERIALIZER, "post_filter", new String[0]);
        op.add(Builder::profile, JsonpDeserializer.booleanDeserializer(), "profile", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::rescore, JsonpDeserializer.arrayDeserializer(Rescore._DESERIALIZER), "rescore", new String[0]);
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields", new String[0]);
        op.add(Builder::searchAfter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "search_after", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::slice, SlicedScroll._DESERIALIZER, "slice", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "sort", new String[0]);
        op.add(Builder::source, JsonpDeserializer.jsonValueDeserializer(), "_source", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "fields", new String[0]);
        op.add(Builder::suggest, JsonpDeserializer.jsonValueDeserializer(), "suggest", new String[0]);
        op.add(Builder::terminateAfter, JsonpDeserializer.longDeserializer(), "terminate_after", new String[0]);
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout", new String[0]);
        op.add(Builder::trackScores, JsonpDeserializer.booleanDeserializer(), "track_scores", new String[0]);
        op.add(Builder::version, JsonpDeserializer.booleanDeserializer(), "version", new String[0]);
        op.add(Builder::seqNoPrimaryTerm, JsonpDeserializer.booleanDeserializer(), "seq_no_primary_term", new String[0]);
        op.add(Builder::storedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stored_fields", new String[0]);
        op.add(Builder::pit, PointInTimeReference._DESERIALIZER, "pit", new String[0]);
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings", new String[0]);
        op.add(Builder::stats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stats", new String[0]);
    }

    public static <TDocument> Endpoint<SearchRequest, SearchResponse<TDocument>, ElasticsearchError> createSearchEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(SearchResponse.createSearchResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<SearchRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private List<String> type;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean allowPartialSearchResults;
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private Long batchedReduceSize;
        @Nullable
        private Boolean ccsMinimizeRoundtrips;
        @Nullable
        private DefaultOperator defaultOperator;
        @Nullable
        private String df;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean ignoreThrottled;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Long maxConcurrentShardRequests;
        @Nullable
        private String minCompatibleShardNode;
        @Nullable
        private String preference;
        @Nullable
        private Long preFilterShardSize;
        @Nullable
        private Boolean requestCache;
        @Nullable
        private String routing;
        @Nullable
        private String scroll;
        @Nullable
        private SearchType searchType;
        @Nullable
        private String suggestField;
        @Nullable
        private SuggestMode suggestMode;
        @Nullable
        private Long suggestSize;
        @Nullable
        private String suggestText;
        @Nullable
        private Boolean typedKeys;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private String q;
        @Nullable
        private Map<String, Aggregation> aggs;
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private FieldCollapse collapse;
        @Nullable
        private Boolean explain;
        @Nullable
        private Integer from;
        @Nullable
        private Highlight highlight;
        @Nullable
        private JsonValue trackTotalHits;
        @Nullable
        private List<Map<String, Double>> indicesBoost;
        @Nullable
        private JsonValue docvalueFields;
        @Nullable
        private Double minScore;
        @Nullable
        private Query postFilter;
        @Nullable
        private Boolean profile;
        @Nullable
        private Query query;
        @Nullable
        private List<Rescore> rescore;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        @Nullable
        private List<String> searchAfter;
        @Nullable
        private Integer size;
        @Nullable
        private SlicedScroll slice;
        @Nullable
        private List<JsonValue> sort;
        @Nullable
        private JsonValue source;
        @Nullable
        private List<JsonValue> fields;
        @Nullable
        private JsonValue suggest;
        @Nullable
        private Long terminateAfter;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean trackScores;
        @Nullable
        private Boolean version;
        @Nullable
        private Boolean seqNoPrimaryTerm;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private PointInTimeReference pit;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private List<String> stats;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder type(@Nullable List<String> value) {
            this.type = value;
            return this;
        }

        public Builder type(String ... value) {
            this.type = Arrays.asList(value);
            return this;
        }

        public Builder addType(String value) {
            if (this.type == null) {
                this.type = new ArrayList<String>();
            }
            this.type.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder allowPartialSearchResults(@Nullable Boolean value) {
            this.allowPartialSearchResults = value;
            return this;
        }

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        public Builder batchedReduceSize(@Nullable Long value) {
            this.batchedReduceSize = value;
            return this;
        }

        public Builder ccsMinimizeRoundtrips(@Nullable Boolean value) {
            this.ccsMinimizeRoundtrips = value;
            return this;
        }

        public Builder defaultOperator(@Nullable DefaultOperator value) {
            this.defaultOperator = value;
            return this;
        }

        public Builder df(@Nullable String value) {
            this.df = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public Builder maxConcurrentShardRequests(@Nullable Long value) {
            this.maxConcurrentShardRequests = value;
            return this;
        }

        public Builder minCompatibleShardNode(@Nullable String value) {
            this.minCompatibleShardNode = value;
            return this;
        }

        public Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public Builder preFilterShardSize(@Nullable Long value) {
            this.preFilterShardSize = value;
            return this;
        }

        public Builder requestCache(@Nullable Boolean value) {
            this.requestCache = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder scroll(@Nullable String value) {
            this.scroll = value;
            return this;
        }

        public Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public Builder suggestField(@Nullable String value) {
            this.suggestField = value;
            return this;
        }

        public Builder suggestMode(@Nullable SuggestMode value) {
            this.suggestMode = value;
            return this;
        }

        public Builder suggestSize(@Nullable Long value) {
            this.suggestSize = value;
            return this;
        }

        public Builder suggestText(@Nullable String value) {
            this.suggestText = value;
            return this;
        }

        public Builder typedKeys(@Nullable Boolean value) {
            this.typedKeys = value;
            return this;
        }

        public Builder sourceExcludes(@Nullable List<String> value) {
            this.sourceExcludes = value;
            return this;
        }

        public Builder sourceExcludes(String ... value) {
            this.sourceExcludes = Arrays.asList(value);
            return this;
        }

        public Builder addSourceExcludes(String value) {
            if (this.sourceExcludes == null) {
                this.sourceExcludes = new ArrayList<String>();
            }
            this.sourceExcludes.add(value);
            return this;
        }

        public Builder sourceIncludes(@Nullable List<String> value) {
            this.sourceIncludes = value;
            return this;
        }

        public Builder sourceIncludes(String ... value) {
            this.sourceIncludes = Arrays.asList(value);
            return this;
        }

        public Builder addSourceIncludes(String value) {
            if (this.sourceIncludes == null) {
                this.sourceIncludes = new ArrayList<String>();
            }
            this.sourceIncludes.add(value);
            return this;
        }

        public Builder q(@Nullable String value) {
            this.q = value;
            return this;
        }

        public Builder aggs(@Nullable Map<String, Aggregation> value) {
            this.aggs = value;
            return this;
        }

        public Builder putAggs(String key, Aggregation value) {
            if (this.aggs == null) {
                this.aggs = new HashMap<String, Aggregation>();
            }
            this.aggs.put(key, value);
            return this;
        }

        public Builder aggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggs(Collections.singletonMap(key, fn.apply(new Aggregation.Builder()).build()));
        }

        public Builder putAggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.putAggs(key, fn.apply(new Aggregation.Builder()).build());
        }

        public Builder aggregations(@Nullable Map<String, Aggregation> value) {
            this.aggregations = value;
            return this;
        }

        public Builder putAggregations(String key, Aggregation value) {
            if (this.aggregations == null) {
                this.aggregations = new HashMap<String, Aggregation>();
            }
            this.aggregations.put(key, value);
            return this;
        }

        public Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(Collections.singletonMap(key, fn.apply(new Aggregation.Builder()).build()));
        }

        public Builder putAggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.putAggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public Builder collapse(@Nullable FieldCollapse value) {
            this.collapse = value;
            return this;
        }

        public Builder collapse(Function<FieldCollapse.Builder, ObjectBuilder<FieldCollapse>> fn) {
            return this.collapse(fn.apply(new FieldCollapse.Builder()).build());
        }

        public Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder highlight(@Nullable Highlight value) {
            this.highlight = value;
            return this;
        }

        public Builder highlight(Function<Highlight.Builder, ObjectBuilder<Highlight>> fn) {
            return this.highlight(fn.apply(new Highlight.Builder()).build());
        }

        public Builder trackTotalHits(@Nullable JsonValue value) {
            this.trackTotalHits = value;
            return this;
        }

        public Builder indicesBoost(@Nullable List<Map<String, Double>> value) {
            this.indicesBoost = value;
            return this;
        }

        public Builder indicesBoost(Map<String, Double> ... value) {
            this.indicesBoost = Arrays.asList(value);
            return this;
        }

        public Builder addIndicesBoost(Map<String, Double> value) {
            if (this.indicesBoost == null) {
                this.indicesBoost = new ArrayList<Map<String, Double>>();
            }
            this.indicesBoost.add(value);
            return this;
        }

        public Builder docvalueFields(@Nullable JsonValue value) {
            this.docvalueFields = value;
            return this;
        }

        public Builder minScore(@Nullable Double value) {
            this.minScore = value;
            return this;
        }

        public Builder postFilter(@Nullable Query value) {
            this.postFilter = value;
            return this;
        }

        public Builder postFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.postFilter(fn.apply(new Query.Builder()).build());
        }

        public Builder profile(@Nullable Boolean value) {
            this.profile = value;
            return this;
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder rescore(@Nullable List<Rescore> value) {
            this.rescore = value;
            return this;
        }

        public Builder rescore(Rescore ... value) {
            this.rescore = Arrays.asList(value);
            return this;
        }

        public Builder addRescore(Rescore value) {
            if (this.rescore == null) {
                this.rescore = new ArrayList<Rescore>();
            }
            this.rescore.add(value);
            return this;
        }

        public Builder rescore(Function<Rescore.Builder, ObjectBuilder<Rescore>> fn) {
            return this.rescore(fn.apply(new Rescore.Builder()).build());
        }

        public Builder addRescore(Function<Rescore.Builder, ObjectBuilder<Rescore>> fn) {
            return this.addRescore(fn.apply(new Rescore.Builder()).build());
        }

        public Builder scriptFields(@Nullable Map<String, ScriptField> value) {
            this.scriptFields = value;
            return this;
        }

        public Builder putScriptFields(String key, ScriptField value) {
            if (this.scriptFields == null) {
                this.scriptFields = new HashMap<String, ScriptField>();
            }
            this.scriptFields.put(key, value);
            return this;
        }

        public Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(Collections.singletonMap(key, fn.apply(new ScriptField.Builder()).build()));
        }

        public Builder putScriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.putScriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public Builder searchAfter(@Nullable List<String> value) {
            this.searchAfter = value;
            return this;
        }

        public Builder searchAfter(String ... value) {
            this.searchAfter = Arrays.asList(value);
            return this;
        }

        public Builder addSearchAfter(String value) {
            if (this.searchAfter == null) {
                this.searchAfter = new ArrayList<String>();
            }
            this.searchAfter.add(value);
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder slice(@Nullable SlicedScroll value) {
            this.slice = value;
            return this;
        }

        public Builder slice(Function<SlicedScroll.Builder, ObjectBuilder<SlicedScroll>> fn) {
            return this.slice(fn.apply(new SlicedScroll.Builder()).build());
        }

        public Builder sort(@Nullable List<JsonValue> value) {
            this.sort = value;
            return this;
        }

        public Builder sort(JsonValue ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder addSort(JsonValue value) {
            if (this.sort == null) {
                this.sort = new ArrayList<JsonValue>();
            }
            this.sort.add(value);
            return this;
        }

        public Builder source(@Nullable JsonValue value) {
            this.source = value;
            return this;
        }

        public Builder fields(@Nullable List<JsonValue> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(JsonValue ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(JsonValue value) {
            if (this.fields == null) {
                this.fields = new ArrayList<JsonValue>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder suggest(@Nullable JsonValue value) {
            this.suggest = value;
            return this;
        }

        public Builder terminateAfter(@Nullable Long value) {
            this.terminateAfter = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder trackScores(@Nullable Boolean value) {
            this.trackScores = value;
            return this;
        }

        public Builder version(@Nullable Boolean value) {
            this.version = value;
            return this;
        }

        public Builder seqNoPrimaryTerm(@Nullable Boolean value) {
            this.seqNoPrimaryTerm = value;
            return this;
        }

        public Builder storedFields(@Nullable List<String> value) {
            this.storedFields = value;
            return this;
        }

        public Builder storedFields(String ... value) {
            this.storedFields = Arrays.asList(value);
            return this;
        }

        public Builder addStoredFields(String value) {
            if (this.storedFields == null) {
                this.storedFields = new ArrayList<String>();
            }
            this.storedFields.add(value);
            return this;
        }

        public Builder pit(@Nullable PointInTimeReference value) {
            this.pit = value;
            return this;
        }

        public Builder pit(Function<PointInTimeReference.Builder, ObjectBuilder<PointInTimeReference>> fn) {
            return this.pit(fn.apply(new PointInTimeReference.Builder()).build());
        }

        public Builder runtimeMappings(@Nullable Map<String, RuntimeField> value) {
            this.runtimeMappings = value;
            return this;
        }

        public Builder putRuntimeMappings(String key, RuntimeField value) {
            if (this.runtimeMappings == null) {
                this.runtimeMappings = new HashMap<String, RuntimeField>();
            }
            this.runtimeMappings.put(key, value);
            return this;
        }

        public Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(Collections.singletonMap(key, fn.apply(new RuntimeField.Builder()).build()));
        }

        public Builder putRuntimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.putRuntimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public Builder stats(@Nullable List<String> value) {
            this.stats = value;
            return this;
        }

        public Builder stats(String ... value) {
            this.stats = Arrays.asList(value);
            return this;
        }

        public Builder addStats(String value) {
            if (this.stats == null) {
                this.stats = new ArrayList<String>();
            }
            this.stats.add(value);
            return this;
        }

        @Override
        public SearchRequest build() {
            return new SearchRequest(this);
        }
    }
}

