/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch.core.reindex_rethrottle.ReindexNode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class ReindexRethrottleResponse
implements JsonpSerializable {
    private final Map<String, ReindexNode> nodes;
    public static final JsonpDeserializer<ReindexRethrottleResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexRethrottleResponse::setupReindexRethrottleResponseDeserializer, Builder::build);

    public ReindexRethrottleResponse(Builder builder) {
        this.nodes = ModelTypeHelper.unmodifiableNonNull(builder.nodes, "nodes");
    }

    public ReindexRethrottleResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, ReindexNode> nodes() {
        return this.nodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry<String, ReindexNode> item0 : this.nodes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupReindexRethrottleResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(ReindexNode._DESERIALIZER), "nodes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ReindexRethrottleResponse> {
        private Map<String, ReindexNode> nodes;

        public Builder nodes(Map<String, ReindexNode> value) {
            this.nodes = value;
            return this;
        }

        public Builder putNodes(String key, ReindexNode value) {
            if (this.nodes == null) {
                this.nodes = new HashMap<String, ReindexNode>();
            }
            this.nodes.put(key, value);
            return this;
        }

        public Builder nodes(String key, Function<ReindexNode.Builder, ObjectBuilder<ReindexNode>> fn) {
            return this.nodes(Collections.singletonMap(key, fn.apply(new ReindexNode.Builder()).build()));
        }

        public Builder putNodes(String key, Function<ReindexNode.Builder, ObjectBuilder<ReindexNode>> fn) {
            return this.putNodes(key, fn.apply(new ReindexNode.Builder()).build());
        }

        @Override
        public ReindexRethrottleResponse build() {
            return new ReindexRethrottleResponse(this);
        }
    }
}

