/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.RankEvalResponse;
import co.elastic.clients.elasticsearch.core.rank_eval.RankEvalMetric;
import co.elastic.clients.elasticsearch.core.rank_eval.RankEvalRequestItem;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RankEvalRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> index;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final String searchType;
    private final List<RankEvalRequestItem> requests;
    @Nullable
    private final RankEvalMetric metric;
    public static final JsonpDeserializer<RankEvalRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalRequest::setupRankEvalRequestDeserializer, Builder::build);
    public static final Endpoint<RankEvalRequest, RankEvalResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<RankEvalRequest, RankEvalResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (!(propsSet |= true)) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_rank_eval");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_rank_eval");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, RankEvalResponse._DESERIALIZER);

    public RankEvalRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.searchType = builder.searchType;
        this.requests = ModelTypeHelper.unmodifiableNonNull(builder.requests, "requests");
        this.metric = builder.metric;
    }

    public RankEvalRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> index() {
        return this.index;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public String searchType() {
        return this.searchType;
    }

    public List<RankEvalRequestItem> requests() {
        return this.requests;
    }

    @Nullable
    public RankEvalMetric metric() {
        return this.metric;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("requests");
        generator.writeStartArray();
        for (RankEvalRequestItem item0 : this.requests) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.metric != null) {
            generator.writeKey("metric");
            this.metric.serialize(generator, mapper);
        }
    }

    protected static void setupRankEvalRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::requests, JsonpDeserializer.arrayDeserializer(RankEvalRequestItem._DESERIALIZER), "requests", new String[0]);
        op.add(Builder::metric, RankEvalMetric._DESERIALIZER, "metric", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RankEvalRequest> {
        private List<String> index;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private String searchType;
        private List<RankEvalRequestItem> requests;
        @Nullable
        private RankEvalMetric metric;

        public Builder index(List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder searchType(@Nullable String value) {
            this.searchType = value;
            return this;
        }

        public Builder requests(List<RankEvalRequestItem> value) {
            this.requests = value;
            return this;
        }

        public Builder requests(RankEvalRequestItem ... value) {
            this.requests = Arrays.asList(value);
            return this;
        }

        public Builder addRequests(RankEvalRequestItem value) {
            if (this.requests == null) {
                this.requests = new ArrayList<RankEvalRequestItem>();
            }
            this.requests.add(value);
            return this;
        }

        public Builder requests(Function<RankEvalRequestItem.Builder, ObjectBuilder<RankEvalRequestItem>> fn) {
            return this.requests(fn.apply(new RankEvalRequestItem.Builder()).build());
        }

        public Builder addRequests(Function<RankEvalRequestItem.Builder, ObjectBuilder<RankEvalRequestItem>> fn) {
            return this.addRequests(fn.apply(new RankEvalRequestItem.Builder()).build());
        }

        public Builder metric(@Nullable RankEvalMetric value) {
            this.metric = value;
            return this;
        }

        public Builder metric(Function<RankEvalMetric.Builder, ObjectBuilder<RankEvalMetric>> fn) {
            return this.metric(fn.apply(new RankEvalMetric.Builder()).build());
        }

        @Override
        public RankEvalRequest build() {
            return new RankEvalRequest(this);
        }
    }
}

