/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class MsearchTemplateResponse<TDocument>
implements JsonpSerializable {
    private final List<JsonValue> responses;
    private final long took;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public MsearchTemplateResponse(Builder<TDocument> builder) {
        this.responses = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).responses, "responses");
        this.took = Objects.requireNonNull(((Builder)builder).took, "took");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public MsearchTemplateResponse(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public List<JsonValue> responses() {
        return this.responses;
    }

    public long took() {
        return this.took;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("responses");
        generator.writeStartArray();
        for (JsonValue item0 : this.responses) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("took");
        generator.write(this.took);
    }

    public static <TDocument> JsonpDeserializer<MsearchTemplateResponse<TDocument>> createMsearchTemplateResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> MsearchTemplateResponse.setupMsearchTemplateResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupMsearchTemplateResponseDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::responses, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "responses", new String[0]);
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<MsearchTemplateResponse<TDocument>> {
        private List<JsonValue> responses;
        private Long took;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> responses(List<JsonValue> value) {
            this.responses = value;
            return this;
        }

        public Builder<TDocument> responses(JsonValue ... value) {
            this.responses = Arrays.asList(value);
            return this;
        }

        public Builder<TDocument> addResponses(JsonValue value) {
            if (this.responses == null) {
                this.responses = new ArrayList<JsonValue>();
            }
            this.responses.add(value);
            return this;
        }

        public Builder<TDocument> took(long value) {
            this.took = value;
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public MsearchTemplateResponse<TDocument> build() {
            return new MsearchTemplateResponse(this);
        }
    }
}

