/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch.core.MsearchTemplateResponse;
import co.elastic.clients.elasticsearch.core.msearch_template.TemplateItem;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MsearchTemplateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final List<String> index;
    @Nullable
    private final List<String> type;
    @Nullable
    private final Boolean ccsMinimizeRoundtrips;
    @Nullable
    private final Long maxConcurrentSearches;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final Boolean typedKeys;
    private final List<TemplateItem> searchTemplates;
    public static final JsonpDeserializer<MsearchTemplateRequest> _DESERIALIZER = MsearchTemplateRequest.createMsearchTemplateRequestDeserializer();
    private static final SimpleEndpoint<MsearchTemplateRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        if (request.index() != null) {
            propsSet |= 1;
        }
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_msearch");
            buf.append("/template");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_msearch");
            buf.append("/template");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_msearch");
            buf.append("/template");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.ccsMinimizeRoundtrips != null) {
            params.put("ccs_minimize_roundtrips", String.valueOf(request.ccsMinimizeRoundtrips));
        }
        if (request.maxConcurrentSearches != null) {
            params.put("max_concurrent_searches", String.valueOf(request.maxConcurrentSearches));
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType.toString());
        }
        if (request.typedKeys != null) {
            params.put("typed_keys", String.valueOf(request.typedKeys));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    public MsearchTemplateRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.type = ModelTypeHelper.unmodifiable(builder.type);
        this.ccsMinimizeRoundtrips = builder.ccsMinimizeRoundtrips;
        this.maxConcurrentSearches = builder.maxConcurrentSearches;
        this.searchType = builder.searchType;
        this.typedKeys = builder.typedKeys;
        this.searchTemplates = ModelTypeHelper.unmodifiableNonNull(builder.searchTemplates, "_value_body");
    }

    public MsearchTemplateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public List<String> type() {
        return this.type;
    }

    @Nullable
    public Boolean ccsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    @Nullable
    public Long maxConcurrentSearches() {
        return this.maxConcurrentSearches;
    }

    @Nullable
    public SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public Boolean typedKeys() {
        return this.typedKeys;
    }

    public List<TemplateItem> searchTemplates() {
        return this.searchTemplates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (TemplateItem item0 : this.searchTemplates) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static JsonpDeserializer<MsearchTemplateRequest> createMsearchTemplateRequestDeserializer() {
        JsonpDeserializer<List<TemplateItem>> valueDeserializer = JsonpDeserializer.arrayDeserializer(TemplateItem._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().searchTemplates((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static <TDocument> Endpoint<MsearchTemplateRequest, MsearchTemplateResponse<TDocument>, ElasticsearchError> createMsearchTemplateEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(MsearchTemplateResponse.createMsearchTemplateResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<MsearchTemplateRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private List<String> type;
        @Nullable
        private Boolean ccsMinimizeRoundtrips;
        @Nullable
        private Long maxConcurrentSearches;
        @Nullable
        private SearchType searchType;
        @Nullable
        private Boolean typedKeys;
        private List<TemplateItem> searchTemplates;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder type(@Nullable List<String> value) {
            this.type = value;
            return this;
        }

        public Builder type(String ... value) {
            this.type = Arrays.asList(value);
            return this;
        }

        public Builder addType(String value) {
            if (this.type == null) {
                this.type = new ArrayList<String>();
            }
            this.type.add(value);
            return this;
        }

        public Builder ccsMinimizeRoundtrips(@Nullable Boolean value) {
            this.ccsMinimizeRoundtrips = value;
            return this;
        }

        public Builder maxConcurrentSearches(@Nullable Long value) {
            this.maxConcurrentSearches = value;
            return this;
        }

        public Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public Builder typedKeys(@Nullable Boolean value) {
            this.typedKeys = value;
            return this;
        }

        public Builder searchTemplates(List<TemplateItem> value) {
            this.searchTemplates = value;
            return this;
        }

        public Builder searchTemplates(TemplateItem ... value) {
            this.searchTemplates = Arrays.asList(value);
            return this;
        }

        public Builder addSearchTemplates(TemplateItem value) {
            if (this.searchTemplates == null) {
                this.searchTemplates = new ArrayList<TemplateItem>();
            }
            this.searchTemplates.add(value);
            return this;
        }

        public Builder searchTemplates(Function<TemplateItem.Builder, ObjectBuilder<TemplateItem>> fn) {
            return this.searchTemplates(fn.apply(new TemplateItem.Builder()).build());
        }

        public Builder addSearchTemplates(Function<TemplateItem.Builder, ObjectBuilder<TemplateItem>> fn) {
            return this.addSearchTemplates(fn.apply(new TemplateItem.Builder()).build());
        }

        @Override
        public MsearchTemplateRequest build() {
            return new MsearchTemplateRequest(this);
        }
    }
}

