/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetSourceResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetSourceRequest
extends GetRequest {
    @Nullable
    private final String index;
    @Nullable
    private final String id;
    @Nullable
    private final String type;
    private static final SimpleEndpoint<GetSourceRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "GET", request -> {
        boolean _index = true;
        int _id = 2;
        int _type = 4;
        int propsSet = 0;
        if (request.index() != null) {
            propsSet |= 1;
        }
        if (request.id() != null) {
            propsSet |= 2;
        }
        if (request.type() != null) {
            propsSet |= 4;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_source");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_source");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, null);

    public GetSourceRequest(Builder builder) {
        super(builder);
        this.index = builder.index;
        this.id = builder.id;
        this.type = builder.type;
    }

    public GetSourceRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    @Nullable
    public String index() {
        return this.index;
    }

    @Override
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public String type() {
        return this.type;
    }

    public static <TDocument> Endpoint<GetSourceRequest, GetSourceResponse<TDocument>, ElasticsearchError> createGetSourceEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(GetSourceResponse.createGetSourceResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    extends GetRequest.AbstractBuilder<Builder>
    implements ObjectBuilder<GetSourceRequest> {
        @Nullable
        private String index;
        @Nullable
        private String id;
        @Nullable
        private String type;

        @Override
        public Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Override
        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Override
        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetSourceRequest build() {
            return new GetSourceRequest(this);
        }
    }
}

