/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.GetScriptResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetScriptRequest
extends RequestBase {
    private final String id;
    @Nullable
    private final String masterTimeout;
    public static final Endpoint<GetScriptRequest, GetScriptResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetScriptRequest, GetScriptResponse>(request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_scripts");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetScriptResponse._DESERIALIZER);

    public GetScriptRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.masterTimeout = builder.masterTimeout;
    }

    public GetScriptRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    public static class Builder
    implements ObjectBuilder<GetScriptRequest> {
        private String id;
        @Nullable
        private String masterTimeout;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        @Override
        public GetScriptRequest build() {
            return new GetScriptRequest(this);
        }
    }
}

