/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch.core.get_script_languages.LanguageContext;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class GetScriptLanguagesResponse
implements JsonpSerializable {
    private final List<LanguageContext> languageContexts;
    private final List<String> typesAllowed;
    public static final JsonpDeserializer<GetScriptLanguagesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetScriptLanguagesResponse::setupGetScriptLanguagesResponseDeserializer, Builder::build);

    public GetScriptLanguagesResponse(Builder builder) {
        this.languageContexts = ModelTypeHelper.unmodifiableNonNull(builder.languageContexts, "language_contexts");
        this.typesAllowed = ModelTypeHelper.unmodifiableNonNull(builder.typesAllowed, "types_allowed");
    }

    public GetScriptLanguagesResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<LanguageContext> languageContexts() {
        return this.languageContexts;
    }

    public List<String> typesAllowed() {
        return this.typesAllowed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("language_contexts");
        generator.writeStartArray();
        for (LanguageContext languageContext : this.languageContexts) {
            languageContext.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("types_allowed");
        generator.writeStartArray();
        for (String string : this.typesAllowed) {
            generator.write(string);
        }
        generator.writeEnd();
    }

    protected static void setupGetScriptLanguagesResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::languageContexts, JsonpDeserializer.arrayDeserializer(LanguageContext._DESERIALIZER), "language_contexts", new String[0]);
        op.add(Builder::typesAllowed, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "types_allowed", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetScriptLanguagesResponse> {
        private List<LanguageContext> languageContexts;
        private List<String> typesAllowed;

        public Builder languageContexts(List<LanguageContext> value) {
            this.languageContexts = value;
            return this;
        }

        public Builder languageContexts(LanguageContext ... value) {
            this.languageContexts = Arrays.asList(value);
            return this;
        }

        public Builder addLanguageContexts(LanguageContext value) {
            if (this.languageContexts == null) {
                this.languageContexts = new ArrayList<LanguageContext>();
            }
            this.languageContexts.add(value);
            return this;
        }

        public Builder languageContexts(Function<LanguageContext.Builder, ObjectBuilder<LanguageContext>> fn) {
            return this.languageContexts(fn.apply(new LanguageContext.Builder()).build());
        }

        public Builder addLanguageContexts(Function<LanguageContext.Builder, ObjectBuilder<LanguageContext>> fn) {
            return this.addLanguageContexts(fn.apply(new LanguageContext.Builder()).build());
        }

        public Builder typesAllowed(List<String> value) {
            this.typesAllowed = value;
            return this;
        }

        public Builder typesAllowed(String ... value) {
            this.typesAllowed = Arrays.asList(value);
            return this;
        }

        public Builder addTypesAllowed(String value) {
            if (this.typesAllowed == null) {
                this.typesAllowed = new ArrayList<String>();
            }
            this.typesAllowed.add(value);
            return this;
        }

        @Override
        public GetScriptLanguagesResponse build() {
            return new GetScriptLanguagesResponse(this);
        }
    }
}

