/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.FieldCapsResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FieldCapsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final List<String> index;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeUnmapped;
    @Nullable
    private final Query indexFilter;
    @Nullable
    private final Map<String, RuntimeField> runtimeMappings;
    public static final JsonpDeserializer<FieldCapsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldCapsRequest::setupFieldCapsRequestDeserializer, Builder::build);
    public static final Endpoint<FieldCapsRequest, FieldCapsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<FieldCapsRequest, FieldCapsResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_field_caps");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_field_caps");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.fields != null) {
            params.put("fields", request.fields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.includeUnmapped != null) {
            params.put("include_unmapped", String.valueOf(request.includeUnmapped));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, FieldCapsResponse._DESERIALIZER);

    public FieldCapsRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeUnmapped = builder.includeUnmapped;
        this.indexFilter = builder.indexFilter;
        this.runtimeMappings = ModelTypeHelper.unmodifiable(builder.runtimeMappings);
    }

    public FieldCapsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Boolean includeUnmapped() {
        return this.includeUnmapped;
    }

    @Nullable
    public Query indexFilter() {
        return this.indexFilter;
    }

    @Nullable
    public Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.indexFilter != null) {
            generator.writeKey("index_filter");
            this.indexFilter.serialize(generator, mapper);
        }
        if (this.runtimeMappings != null) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry<String, RuntimeField> item0 : this.runtimeMappings.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupFieldCapsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indexFilter, Query._DESERIALIZER, "index_filter", new String[0]);
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldCapsRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeUnmapped;
        @Nullable
        private Query indexFilter;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder includeUnmapped(@Nullable Boolean value) {
            this.includeUnmapped = value;
            return this;
        }

        public Builder indexFilter(@Nullable Query value) {
            this.indexFilter = value;
            return this;
        }

        public Builder indexFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.indexFilter(fn.apply(new Query.Builder()).build());
        }

        public Builder runtimeMappings(@Nullable Map<String, RuntimeField> value) {
            this.runtimeMappings = value;
            return this;
        }

        public Builder putRuntimeMappings(String key, RuntimeField value) {
            if (this.runtimeMappings == null) {
                this.runtimeMappings = new HashMap<String, RuntimeField>();
            }
            this.runtimeMappings.put(key, value);
            return this;
        }

        public Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(Collections.singletonMap(key, fn.apply(new RuntimeField.Builder()).build()));
        }

        public Builder putRuntimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.putRuntimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        @Override
        public FieldCapsRequest build() {
            return new FieldCapsRequest(this);
        }
    }
}

