/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.BooleanEndpoint;
import co.elastic.clients.base.BooleanResponse;
import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ExistsSourceRequest
extends RequestBase {
    private final String id;
    private final String index;
    @Nullable
    private final String type;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean realtime;
    @Nullable
    private final Boolean refresh;
    @Nullable
    private final String routing;
    @Nullable
    private final JsonValue source;
    @Nullable
    private final List<String> sourceExcludes;
    @Nullable
    private final List<String> sourceIncludes;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final Endpoint<ExistsSourceRequest, BooleanResponse, ElasticsearchError> ENDPOINT = new BooleanEndpoint<ExistsSourceRequest>(request -> "HEAD", request -> {
        boolean _id = true;
        int _index = 2;
        int _type = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if (request.type() != null) {
            propsSet |= 4;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_source");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_source");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, (Function<ExistsSourceRequest, Map<String, String>>)((Function<ExistsSourceRequest, Map>)request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.realtime != null) {
            params.put("realtime", String.valueOf(request.realtime));
        }
        if (request.refresh != null) {
            params.put("refresh", String.valueOf(request.refresh));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.source != null) {
            params.put("_source", JsonpUtils.toString(request.source));
        }
        if (request.sourceExcludes != null) {
            params.put("_source_excludes", request.sourceExcludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.sourceIncludes != null) {
            params.put("_source_includes", request.sourceIncludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.toString());
        }
        return params;
    }), (Function<ExistsSourceRequest, Map<String, String>>)SimpleEndpoint.emptyMap(), false, null);

    public ExistsSourceRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.index = Objects.requireNonNull(builder.index, "index");
        this.type = builder.type;
        this.preference = builder.preference;
        this.realtime = builder.realtime;
        this.refresh = builder.refresh;
        this.routing = builder.routing;
        this.source = builder.source;
        this.sourceExcludes = ModelTypeHelper.unmodifiable(builder.sourceExcludes);
        this.sourceIncludes = ModelTypeHelper.unmodifiable(builder.sourceIncludes);
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public ExistsSourceRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public String preference() {
        return this.preference;
    }

    @Nullable
    public Boolean realtime() {
        return this.realtime;
    }

    @Nullable
    public Boolean refresh() {
        return this.refresh;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public JsonValue source() {
        return this.source;
    }

    @Nullable
    public List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    @Nullable
    public List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public VersionType versionType() {
        return this.versionType;
    }

    public static class Builder
    implements ObjectBuilder<ExistsSourceRequest> {
        private String id;
        private String index;
        @Nullable
        private String type;
        @Nullable
        private String preference;
        @Nullable
        private Boolean realtime;
        @Nullable
        private Boolean refresh;
        @Nullable
        private String routing;
        @Nullable
        private JsonValue source;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public Builder realtime(@Nullable Boolean value) {
            this.realtime = value;
            return this;
        }

        public Builder refresh(@Nullable Boolean value) {
            this.refresh = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder source(@Nullable JsonValue value) {
            this.source = value;
            return this;
        }

        public Builder sourceExcludes(@Nullable List<String> value) {
            this.sourceExcludes = value;
            return this;
        }

        public Builder sourceExcludes(String ... value) {
            this.sourceExcludes = Arrays.asList(value);
            return this;
        }

        public Builder addSourceExcludes(String value) {
            if (this.sourceExcludes == null) {
                this.sourceExcludes = new ArrayList<String>();
            }
            this.sourceExcludes.add(value);
            return this;
        }

        public Builder sourceIncludes(@Nullable List<String> value) {
            this.sourceIncludes = value;
            return this;
        }

        public Builder sourceIncludes(String ... value) {
            this.sourceIncludes = Arrays.asList(value);
            return this;
        }

        public Builder addSourceIncludes(String value) {
            if (this.sourceIncludes == null) {
                this.sourceIncludes = new ArrayList<String>();
            }
            this.sourceIncludes.add(value);
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        public ExistsSourceRequest build() {
            return new ExistsSourceRequest(this);
        }
    }
}

