/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.DeleteScriptResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteScriptRequest
extends RequestBase {
    private final String id;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    public static final Endpoint<DeleteScriptRequest, DeleteScriptResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteScriptRequest, DeleteScriptResponse>(request -> "DELETE", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_scripts");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteScriptResponse._DESERIALIZER);

    public DeleteScriptRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
    }

    public DeleteScriptRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<DeleteScriptRequest> {
        private String id;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public DeleteScriptRequest build() {
            return new DeleteScriptRequest(this);
        }
    }
}

