/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteRequest
extends RequestBase {
    private final String id;
    private final String index;
    @Nullable
    private final String type;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Integer ifSeqNo;
    @Nullable
    private final JsonValue refresh;
    @Nullable
    private final String routing;
    @Nullable
    private final String timeout;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    @Nullable
    private final JsonValue waitForActiveShards;
    public static final Endpoint<DeleteRequest, DeleteResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteRequest, DeleteResponse>(request -> "DELETE", request -> {
        boolean _id = true;
        int _index = 2;
        int _type = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if (request.type() != null) {
            propsSet |= 4;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_doc");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(request.ifPrimaryTerm));
        }
        if (request.ifSeqNo != null) {
            params.put("if_seq_no", String.valueOf(request.ifSeqNo));
        }
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.toString());
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", JsonpUtils.toString(request.waitForActiveShards));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteResponse._DESERIALIZER);

    public DeleteRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.index = Objects.requireNonNull(builder.index, "index");
        this.type = builder.type;
        this.ifPrimaryTerm = builder.ifPrimaryTerm;
        this.ifSeqNo = builder.ifSeqNo;
        this.refresh = builder.refresh;
        this.routing = builder.routing;
        this.timeout = builder.timeout;
        this.version = builder.version;
        this.versionType = builder.versionType;
        this.waitForActiveShards = builder.waitForActiveShards;
    }

    public DeleteRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public Integer ifSeqNo() {
        return this.ifSeqNo;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public VersionType versionType() {
        return this.versionType;
    }

    @Nullable
    public JsonValue waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public static class Builder
    implements ObjectBuilder<DeleteRequest> {
        private String id;
        private String index;
        @Nullable
        private String type;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Integer ifSeqNo;
        @Nullable
        private JsonValue refresh;
        @Nullable
        private String routing;
        @Nullable
        private String timeout;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;
        @Nullable
        private JsonValue waitForActiveShards;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        public Builder ifSeqNo(@Nullable Integer value) {
            this.ifSeqNo = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        public Builder waitForActiveShards(@Nullable JsonValue value) {
            this.waitForActiveShards = value;
            return this;
        }

        @Override
        public DeleteRequest build() {
            return new DeleteRequest(this);
        }
    }
}

