/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRethrottleResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteByQueryRethrottleRequest
extends RequestBase {
    private final String taskId;
    @Nullable
    private final Long requestsPerSecond;
    public static final Endpoint<DeleteByQueryRethrottleRequest, DeleteByQueryRethrottleResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteByQueryRethrottleRequest, DeleteByQueryRethrottleResponse>(request -> "POST", request -> {
        boolean _taskId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_delete_by_query");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskId, buf);
            buf.append("/_rethrottle");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.requestsPerSecond != null) {
            params.put("requests_per_second", String.valueOf(request.requestsPerSecond));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteByQueryRethrottleResponse._DESERIALIZER);

    public DeleteByQueryRethrottleRequest(Builder builder) {
        this.taskId = Objects.requireNonNull(builder.taskId, "task_id");
        this.requestsPerSecond = builder.requestsPerSecond;
    }

    public DeleteByQueryRethrottleRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String taskId() {
        return this.taskId;
    }

    @Nullable
    public Long requestsPerSecond() {
        return this.requestsPerSecond;
    }

    public static class Builder
    implements ObjectBuilder<DeleteByQueryRethrottleRequest> {
        private String taskId;
        @Nullable
        private Long requestsPerSecond;

        public Builder taskId(String value) {
            this.taskId = value;
            return this;
        }

        public Builder requestsPerSecond(@Nullable Long value) {
            this.requestsPerSecond = value;
            return this;
        }

        @Override
        public DeleteByQueryRethrottleRequest build() {
            return new DeleteByQueryRethrottleRequest(this);
        }
    }
}

