/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.ClearScrollResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ClearScrollRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final List<String> scrollId;
    public static final JsonpDeserializer<ClearScrollRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClearScrollRequest::setupClearScrollRequestDeserializer, Builder::build);
    public static final Endpoint<ClearScrollRequest, ClearScrollResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ClearScrollRequest, ClearScrollResponse>(request -> "DELETE", request -> {
        boolean _scrollId = true;
        boolean propsSet = false;
        if (request.scrollId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_search");
            buf.append("/scroll");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_search");
            buf.append("/scroll");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.scrollId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ClearScrollResponse._DESERIALIZER);

    public ClearScrollRequest(Builder builder) {
        this.scrollId = ModelTypeHelper.unmodifiable(builder.scrollId);
    }

    public ClearScrollRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> scrollId() {
        return this.scrollId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
    }

    protected static void setupClearScrollRequestDeserializer(DelegatingDeserializer<Builder> op) {
    }

    public static class Builder
    implements ObjectBuilder<ClearScrollRequest> {
        @Nullable
        private List<String> scrollId;

        public Builder scrollId(@Nullable List<String> value) {
            this.scrollId = value;
            return this;
        }

        public Builder scrollId(String ... value) {
            this.scrollId = Arrays.asList(value);
            return this;
        }

        public Builder addScrollId(String value) {
            if (this.scrollId == null) {
                this.scrollId = new ArrayList<String>();
            }
            this.scrollId.add(value);
            return this;
        }

        @Override
        public ClearScrollRequest build() {
            return new ClearScrollRequest(this);
        }
    }
}

