/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.ClusterOperatingSystemArchitecture;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterOperatingSystemName;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterOperatingSystemPrettyName;
import co.elastic.clients.elasticsearch.cluster.stats.OperatingSystemMemoryInfo;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ClusterOperatingSystem
implements JsonpSerializable {
    private final int allocatedProcessors;
    private final int availableProcessors;
    private final OperatingSystemMemoryInfo mem;
    private final List<ClusterOperatingSystemName> names;
    private final List<ClusterOperatingSystemPrettyName> prettyNames;
    @Nullable
    private final List<ClusterOperatingSystemArchitecture> architectures;
    public static final JsonpDeserializer<ClusterOperatingSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterOperatingSystem::setupClusterOperatingSystemDeserializer, Builder::build);

    public ClusterOperatingSystem(Builder builder) {
        this.allocatedProcessors = Objects.requireNonNull(builder.allocatedProcessors, "allocated_processors");
        this.availableProcessors = Objects.requireNonNull(builder.availableProcessors, "available_processors");
        this.mem = Objects.requireNonNull(builder.mem, "mem");
        this.names = ModelTypeHelper.unmodifiableNonNull(builder.names, "names");
        this.prettyNames = ModelTypeHelper.unmodifiableNonNull(builder.prettyNames, "pretty_names");
        this.architectures = ModelTypeHelper.unmodifiable(builder.architectures);
    }

    public ClusterOperatingSystem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int allocatedProcessors() {
        return this.allocatedProcessors;
    }

    public int availableProcessors() {
        return this.availableProcessors;
    }

    public OperatingSystemMemoryInfo mem() {
        return this.mem;
    }

    public List<ClusterOperatingSystemName> names() {
        return this.names;
    }

    public List<ClusterOperatingSystemPrettyName> prettyNames() {
        return this.prettyNames;
    }

    @Nullable
    public List<ClusterOperatingSystemArchitecture> architectures() {
        return this.architectures;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allocated_processors");
        generator.write(this.allocatedProcessors);
        generator.writeKey("available_processors");
        generator.write(this.availableProcessors);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("names");
        generator.writeStartArray();
        for (ClusterOperatingSystemName clusterOperatingSystemName : this.names) {
            clusterOperatingSystemName.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("pretty_names");
        generator.writeStartArray();
        for (ClusterOperatingSystemPrettyName clusterOperatingSystemPrettyName : this.prettyNames) {
            clusterOperatingSystemPrettyName.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.architectures != null) {
            generator.writeKey("architectures");
            generator.writeStartArray();
            for (ClusterOperatingSystemArchitecture clusterOperatingSystemArchitecture : this.architectures) {
                clusterOperatingSystemArchitecture.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupClusterOperatingSystemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allocatedProcessors, JsonpDeserializer.integerDeserializer(), "allocated_processors", new String[0]);
        op.add(Builder::availableProcessors, JsonpDeserializer.integerDeserializer(), "available_processors", new String[0]);
        op.add(Builder::mem, OperatingSystemMemoryInfo._DESERIALIZER, "mem", new String[0]);
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(ClusterOperatingSystemName._DESERIALIZER), "names", new String[0]);
        op.add(Builder::prettyNames, JsonpDeserializer.arrayDeserializer(ClusterOperatingSystemPrettyName._DESERIALIZER), "pretty_names", new String[0]);
        op.add(Builder::architectures, JsonpDeserializer.arrayDeserializer(ClusterOperatingSystemArchitecture._DESERIALIZER), "architectures", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterOperatingSystem> {
        private Integer allocatedProcessors;
        private Integer availableProcessors;
        private OperatingSystemMemoryInfo mem;
        private List<ClusterOperatingSystemName> names;
        private List<ClusterOperatingSystemPrettyName> prettyNames;
        @Nullable
        private List<ClusterOperatingSystemArchitecture> architectures;

        public Builder allocatedProcessors(int value) {
            this.allocatedProcessors = value;
            return this;
        }

        public Builder availableProcessors(int value) {
            this.availableProcessors = value;
            return this;
        }

        public Builder mem(OperatingSystemMemoryInfo value) {
            this.mem = value;
            return this;
        }

        public Builder mem(Function<OperatingSystemMemoryInfo.Builder, ObjectBuilder<OperatingSystemMemoryInfo>> fn) {
            return this.mem(fn.apply(new OperatingSystemMemoryInfo.Builder()).build());
        }

        public Builder names(List<ClusterOperatingSystemName> value) {
            this.names = value;
            return this;
        }

        public Builder names(ClusterOperatingSystemName ... value) {
            this.names = Arrays.asList(value);
            return this;
        }

        public Builder addNames(ClusterOperatingSystemName value) {
            if (this.names == null) {
                this.names = new ArrayList<ClusterOperatingSystemName>();
            }
            this.names.add(value);
            return this;
        }

        public Builder names(Function<ClusterOperatingSystemName.Builder, ObjectBuilder<ClusterOperatingSystemName>> fn) {
            return this.names(fn.apply(new ClusterOperatingSystemName.Builder()).build());
        }

        public Builder addNames(Function<ClusterOperatingSystemName.Builder, ObjectBuilder<ClusterOperatingSystemName>> fn) {
            return this.addNames(fn.apply(new ClusterOperatingSystemName.Builder()).build());
        }

        public Builder prettyNames(List<ClusterOperatingSystemPrettyName> value) {
            this.prettyNames = value;
            return this;
        }

        public Builder prettyNames(ClusterOperatingSystemPrettyName ... value) {
            this.prettyNames = Arrays.asList(value);
            return this;
        }

        public Builder addPrettyNames(ClusterOperatingSystemPrettyName value) {
            if (this.prettyNames == null) {
                this.prettyNames = new ArrayList<ClusterOperatingSystemPrettyName>();
            }
            this.prettyNames.add(value);
            return this;
        }

        public Builder prettyNames(Function<ClusterOperatingSystemPrettyName.Builder, ObjectBuilder<ClusterOperatingSystemPrettyName>> fn) {
            return this.prettyNames(fn.apply(new ClusterOperatingSystemPrettyName.Builder()).build());
        }

        public Builder addPrettyNames(Function<ClusterOperatingSystemPrettyName.Builder, ObjectBuilder<ClusterOperatingSystemPrettyName>> fn) {
            return this.addPrettyNames(fn.apply(new ClusterOperatingSystemPrettyName.Builder()).build());
        }

        public Builder architectures(@Nullable List<ClusterOperatingSystemArchitecture> value) {
            this.architectures = value;
            return this;
        }

        public Builder architectures(ClusterOperatingSystemArchitecture ... value) {
            this.architectures = Arrays.asList(value);
            return this;
        }

        public Builder addArchitectures(ClusterOperatingSystemArchitecture value) {
            if (this.architectures == null) {
                this.architectures = new ArrayList<ClusterOperatingSystemArchitecture>();
            }
            this.architectures.add(value);
            return this;
        }

        public Builder architectures(Function<ClusterOperatingSystemArchitecture.Builder, ObjectBuilder<ClusterOperatingSystemArchitecture>> fn) {
            return this.architectures(fn.apply(new ClusterOperatingSystemArchitecture.Builder()).build());
        }

        public Builder addArchitectures(Function<ClusterOperatingSystemArchitecture.Builder, ObjectBuilder<ClusterOperatingSystemArchitecture>> fn) {
            return this.addArchitectures(fn.apply(new ClusterOperatingSystemArchitecture.Builder()).build());
        }

        @Override
        public ClusterOperatingSystem build() {
            return new ClusterOperatingSystem(this);
        }
    }
}

