/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.reroute;

import co.elastic.clients.elasticsearch.cluster.reroute.CommandAllocatePrimaryAction;
import co.elastic.clients.elasticsearch.cluster.reroute.CommandAllocateReplicaAction;
import co.elastic.clients.elasticsearch.cluster.reroute.CommandCancelAction;
import co.elastic.clients.elasticsearch.cluster.reroute.CommandMoveAction;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Command
implements JsonpSerializable {
    @Nullable
    private final CommandCancelAction cancel;
    @Nullable
    private final CommandMoveAction move;
    @Nullable
    private final CommandAllocateReplicaAction allocateReplica;
    @Nullable
    private final CommandAllocatePrimaryAction allocateStalePrimary;
    @Nullable
    private final CommandAllocatePrimaryAction allocateEmptyPrimary;
    public static final JsonpDeserializer<Command> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Command::setupCommandDeserializer, Builder::build);

    public Command(Builder builder) {
        this.cancel = builder.cancel;
        this.move = builder.move;
        this.allocateReplica = builder.allocateReplica;
        this.allocateStalePrimary = builder.allocateStalePrimary;
        this.allocateEmptyPrimary = builder.allocateEmptyPrimary;
    }

    public Command(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public CommandCancelAction cancel() {
        return this.cancel;
    }

    @Nullable
    public CommandMoveAction move() {
        return this.move;
    }

    @Nullable
    public CommandAllocateReplicaAction allocateReplica() {
        return this.allocateReplica;
    }

    @Nullable
    public CommandAllocatePrimaryAction allocateStalePrimary() {
        return this.allocateStalePrimary;
    }

    @Nullable
    public CommandAllocatePrimaryAction allocateEmptyPrimary() {
        return this.allocateEmptyPrimary;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cancel != null) {
            generator.writeKey("cancel");
            this.cancel.serialize(generator, mapper);
        }
        if (this.move != null) {
            generator.writeKey("move");
            this.move.serialize(generator, mapper);
        }
        if (this.allocateReplica != null) {
            generator.writeKey("allocate_replica");
            this.allocateReplica.serialize(generator, mapper);
        }
        if (this.allocateStalePrimary != null) {
            generator.writeKey("allocate_stale_primary");
            this.allocateStalePrimary.serialize(generator, mapper);
        }
        if (this.allocateEmptyPrimary != null) {
            generator.writeKey("allocate_empty_primary");
            this.allocateEmptyPrimary.serialize(generator, mapper);
        }
    }

    protected static void setupCommandDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cancel, CommandCancelAction._DESERIALIZER, "cancel", new String[0]);
        op.add(Builder::move, CommandMoveAction._DESERIALIZER, "move", new String[0]);
        op.add(Builder::allocateReplica, CommandAllocateReplicaAction._DESERIALIZER, "allocate_replica", new String[0]);
        op.add(Builder::allocateStalePrimary, CommandAllocatePrimaryAction._DESERIALIZER, "allocate_stale_primary", new String[0]);
        op.add(Builder::allocateEmptyPrimary, CommandAllocatePrimaryAction._DESERIALIZER, "allocate_empty_primary", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Command> {
        @Nullable
        private CommandCancelAction cancel;
        @Nullable
        private CommandMoveAction move;
        @Nullable
        private CommandAllocateReplicaAction allocateReplica;
        @Nullable
        private CommandAllocatePrimaryAction allocateStalePrimary;
        @Nullable
        private CommandAllocatePrimaryAction allocateEmptyPrimary;

        public Builder cancel(@Nullable CommandCancelAction value) {
            this.cancel = value;
            return this;
        }

        public Builder cancel(Function<CommandCancelAction.Builder, ObjectBuilder<CommandCancelAction>> fn) {
            return this.cancel(fn.apply(new CommandCancelAction.Builder()).build());
        }

        public Builder move(@Nullable CommandMoveAction value) {
            this.move = value;
            return this;
        }

        public Builder move(Function<CommandMoveAction.Builder, ObjectBuilder<CommandMoveAction>> fn) {
            return this.move(fn.apply(new CommandMoveAction.Builder()).build());
        }

        public Builder allocateReplica(@Nullable CommandAllocateReplicaAction value) {
            this.allocateReplica = value;
            return this;
        }

        public Builder allocateReplica(Function<CommandAllocateReplicaAction.Builder, ObjectBuilder<CommandAllocateReplicaAction>> fn) {
            return this.allocateReplica(fn.apply(new CommandAllocateReplicaAction.Builder()).build());
        }

        public Builder allocateStalePrimary(@Nullable CommandAllocatePrimaryAction value) {
            this.allocateStalePrimary = value;
            return this;
        }

        public Builder allocateStalePrimary(Function<CommandAllocatePrimaryAction.Builder, ObjectBuilder<CommandAllocatePrimaryAction>> fn) {
            return this.allocateStalePrimary(fn.apply(new CommandAllocatePrimaryAction.Builder()).build());
        }

        public Builder allocateEmptyPrimary(@Nullable CommandAllocatePrimaryAction value) {
            this.allocateEmptyPrimary = value;
            return this;
        }

        public Builder allocateEmptyPrimary(Function<CommandAllocatePrimaryAction.Builder, ObjectBuilder<CommandAllocatePrimaryAction>> fn) {
            return this.allocateEmptyPrimary(fn.apply(new CommandAllocatePrimaryAction.Builder()).build());
        }

        @Override
        public Command build() {
            return new Command(this);
        }
    }
}

