/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch.cluster.ClusterStatus;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterIndices;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterNodes;
import co.elastic.clients.elasticsearch.nodes.NodesResponseBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterStatsResponse
extends NodesResponseBase {
    private final String clusterName;
    private final String clusterUuid;
    private final ClusterIndices indices;
    private final ClusterNodes nodes;
    private final ClusterStatus status;
    private final long timestamp;
    public static final JsonpDeserializer<ClusterStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterStatsResponse::setupClusterStatsResponseDeserializer, Builder::build);

    public ClusterStatsResponse(Builder builder) {
        super(builder);
        this.clusterName = Objects.requireNonNull(builder.clusterName, "cluster_name");
        this.clusterUuid = Objects.requireNonNull(builder.clusterUuid, "cluster_uuid");
        this.indices = Objects.requireNonNull(builder.indices, "indices");
        this.nodes = Objects.requireNonNull(builder.nodes, "nodes");
        this.status = Objects.requireNonNull(builder.status, "status");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
    }

    public ClusterStatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String clusterUuid() {
        return this.clusterUuid;
    }

    public ClusterIndices indices() {
        return this.indices;
    }

    public ClusterNodes nodes() {
        return this.nodes;
    }

    public ClusterStatus status() {
        return this.status;
    }

    public long timestamp() {
        return this.timestamp;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("cluster_uuid");
        generator.write(this.clusterUuid);
        generator.writeKey("indices");
        this.indices.serialize(generator, mapper);
        generator.writeKey("nodes");
        this.nodes.serialize(generator, mapper);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupClusterStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        NodesResponseBase.setupNodesResponseBaseDeserializer(op);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name", new String[0]);
        op.add(Builder::clusterUuid, JsonpDeserializer.stringDeserializer(), "cluster_uuid", new String[0]);
        op.add(Builder::indices, ClusterIndices._DESERIALIZER, "indices", new String[0]);
        op.add(Builder::nodes, ClusterNodes._DESERIALIZER, "nodes", new String[0]);
        op.add(Builder::status, ClusterStatus._DESERIALIZER, "status", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp", new String[0]);
    }

    public static class Builder
    extends NodesResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ClusterStatsResponse> {
        private String clusterName;
        private String clusterUuid;
        private ClusterIndices indices;
        private ClusterNodes nodes;
        private ClusterStatus status;
        private Long timestamp;

        public Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public Builder clusterUuid(String value) {
            this.clusterUuid = value;
            return this;
        }

        public Builder indices(ClusterIndices value) {
            this.indices = value;
            return this;
        }

        public Builder indices(Function<ClusterIndices.Builder, ObjectBuilder<ClusterIndices>> fn) {
            return this.indices(fn.apply(new ClusterIndices.Builder()).build());
        }

        public Builder nodes(ClusterNodes value) {
            this.nodes = value;
            return this;
        }

        public Builder nodes(Function<ClusterNodes.Builder, ObjectBuilder<ClusterNodes>> fn) {
            return this.nodes(fn.apply(new ClusterNodes.Builder()).build());
        }

        public Builder status(ClusterStatus value) {
            this.status = value;
            return this;
        }

        public Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterStatsResponse build() {
            return new ClusterStatsResponse(this);
        }
    }
}

