/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.cluster.ClusterStatsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ClusterStatsRequest
extends RequestBase {
    @Nullable
    private final List<String> nodeId;
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final String timeout;
    public static final Endpoint<ClusterStatsRequest, ClusterStatsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ClusterStatsRequest, ClusterStatsResponse>(request -> "GET", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (request.nodeId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/stats");
            buf.append("/nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ClusterStatsResponse._DESERIALIZER);

    public ClusterStatsRequest(Builder builder) {
        this.nodeId = ModelTypeHelper.unmodifiable(builder.nodeId);
        this.flatSettings = builder.flatSettings;
        this.timeout = builder.timeout;
    }

    public ClusterStatsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<ClusterStatsRequest> {
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private String timeout;

        public Builder nodeId(@Nullable List<String> value) {
            this.nodeId = value;
            return this;
        }

        public Builder nodeId(String ... value) {
            this.nodeId = Arrays.asList(value);
            return this;
        }

        public Builder addNodeId(String value) {
            if (this.nodeId == null) {
                this.nodeId = new ArrayList<String>();
            }
            this.nodeId.add(value);
            return this;
        }

        public Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public ClusterStatsRequest build() {
            return new ClusterStatsRequest(this);
        }
    }
}

