/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch.cluster.allocation_explain.AllocationDecision;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.ClusterInfo;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.CurrentNode;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.Decision;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.NodeAllocationExplanation;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.UnassignedInformation;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AllocationExplainResponse
implements JsonpSerializable {
    @Nullable
    private final String allocateExplanation;
    @Nullable
    private final String allocationDelay;
    @Nullable
    private final Long allocationDelayInMillis;
    @Nullable
    private final Decision canAllocate;
    @Nullable
    private final Decision canMoveToOtherNode;
    @Nullable
    private final Decision canRebalanceCluster;
    @Nullable
    private final List<AllocationDecision> canRebalanceClusterDecisions;
    @Nullable
    private final Decision canRebalanceToOtherNode;
    @Nullable
    private final List<AllocationDecision> canRemainDecisions;
    @Nullable
    private final Decision canRemainOnCurrentNode;
    @Nullable
    private final ClusterInfo clusterInfo;
    @Nullable
    private final String configuredDelay;
    @Nullable
    private final Long configuredDelayInMillis;
    @Nullable
    private final CurrentNode currentNode;
    private final String currentState;
    private final String index;
    @Nullable
    private final String moveExplanation;
    @Nullable
    private final List<NodeAllocationExplanation> nodeAllocationDecisions;
    private final boolean primary;
    @Nullable
    private final String rebalanceExplanation;
    @Nullable
    private final String remainingDelay;
    @Nullable
    private final Long remainingDelayInMillis;
    private final int shard;
    @Nullable
    private final UnassignedInformation unassignedInfo;
    @Nullable
    private final String note;
    public static final JsonpDeserializer<AllocationExplainResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocationExplainResponse::setupAllocationExplainResponseDeserializer, Builder::build);

    public AllocationExplainResponse(Builder builder) {
        this.allocateExplanation = builder.allocateExplanation;
        this.allocationDelay = builder.allocationDelay;
        this.allocationDelayInMillis = builder.allocationDelayInMillis;
        this.canAllocate = builder.canAllocate;
        this.canMoveToOtherNode = builder.canMoveToOtherNode;
        this.canRebalanceCluster = builder.canRebalanceCluster;
        this.canRebalanceClusterDecisions = ModelTypeHelper.unmodifiable(builder.canRebalanceClusterDecisions);
        this.canRebalanceToOtherNode = builder.canRebalanceToOtherNode;
        this.canRemainDecisions = ModelTypeHelper.unmodifiable(builder.canRemainDecisions);
        this.canRemainOnCurrentNode = builder.canRemainOnCurrentNode;
        this.clusterInfo = builder.clusterInfo;
        this.configuredDelay = builder.configuredDelay;
        this.configuredDelayInMillis = builder.configuredDelayInMillis;
        this.currentNode = builder.currentNode;
        this.currentState = Objects.requireNonNull(builder.currentState, "current_state");
        this.index = Objects.requireNonNull(builder.index, "index");
        this.moveExplanation = builder.moveExplanation;
        this.nodeAllocationDecisions = ModelTypeHelper.unmodifiable(builder.nodeAllocationDecisions);
        this.primary = Objects.requireNonNull(builder.primary, "primary");
        this.rebalanceExplanation = builder.rebalanceExplanation;
        this.remainingDelay = builder.remainingDelay;
        this.remainingDelayInMillis = builder.remainingDelayInMillis;
        this.shard = Objects.requireNonNull(builder.shard, "shard");
        this.unassignedInfo = builder.unassignedInfo;
        this.note = builder.note;
    }

    public AllocationExplainResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String allocateExplanation() {
        return this.allocateExplanation;
    }

    @Nullable
    public String allocationDelay() {
        return this.allocationDelay;
    }

    @Nullable
    public Long allocationDelayInMillis() {
        return this.allocationDelayInMillis;
    }

    @Nullable
    public Decision canAllocate() {
        return this.canAllocate;
    }

    @Nullable
    public Decision canMoveToOtherNode() {
        return this.canMoveToOtherNode;
    }

    @Nullable
    public Decision canRebalanceCluster() {
        return this.canRebalanceCluster;
    }

    @Nullable
    public List<AllocationDecision> canRebalanceClusterDecisions() {
        return this.canRebalanceClusterDecisions;
    }

    @Nullable
    public Decision canRebalanceToOtherNode() {
        return this.canRebalanceToOtherNode;
    }

    @Nullable
    public List<AllocationDecision> canRemainDecisions() {
        return this.canRemainDecisions;
    }

    @Nullable
    public Decision canRemainOnCurrentNode() {
        return this.canRemainOnCurrentNode;
    }

    @Nullable
    public ClusterInfo clusterInfo() {
        return this.clusterInfo;
    }

    @Nullable
    public String configuredDelay() {
        return this.configuredDelay;
    }

    @Nullable
    public Long configuredDelayInMillis() {
        return this.configuredDelayInMillis;
    }

    @Nullable
    public CurrentNode currentNode() {
        return this.currentNode;
    }

    public String currentState() {
        return this.currentState;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String moveExplanation() {
        return this.moveExplanation;
    }

    @Nullable
    public List<NodeAllocationExplanation> nodeAllocationDecisions() {
        return this.nodeAllocationDecisions;
    }

    public boolean primary() {
        return this.primary;
    }

    @Nullable
    public String rebalanceExplanation() {
        return this.rebalanceExplanation;
    }

    @Nullable
    public String remainingDelay() {
        return this.remainingDelay;
    }

    @Nullable
    public Long remainingDelayInMillis() {
        return this.remainingDelayInMillis;
    }

    public int shard() {
        return this.shard;
    }

    @Nullable
    public UnassignedInformation unassignedInfo() {
        return this.unassignedInfo;
    }

    @Nullable
    public String note() {
        return this.note;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allocateExplanation != null) {
            generator.writeKey("allocate_explanation");
            generator.write(this.allocateExplanation);
        }
        if (this.allocationDelay != null) {
            generator.writeKey("allocation_delay");
            generator.write(this.allocationDelay);
        }
        if (this.allocationDelayInMillis != null) {
            generator.writeKey("allocation_delay_in_millis");
            generator.write(this.allocationDelayInMillis.longValue());
        }
        if (this.canAllocate != null) {
            generator.writeKey("can_allocate");
            this.canAllocate.serialize(generator, mapper);
        }
        if (this.canMoveToOtherNode != null) {
            generator.writeKey("can_move_to_other_node");
            this.canMoveToOtherNode.serialize(generator, mapper);
        }
        if (this.canRebalanceCluster != null) {
            generator.writeKey("can_rebalance_cluster");
            this.canRebalanceCluster.serialize(generator, mapper);
        }
        if (this.canRebalanceClusterDecisions != null) {
            generator.writeKey("can_rebalance_cluster_decisions");
            generator.writeStartArray();
            for (AllocationDecision allocationDecision : this.canRebalanceClusterDecisions) {
                allocationDecision.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.canRebalanceToOtherNode != null) {
            generator.writeKey("can_rebalance_to_other_node");
            this.canRebalanceToOtherNode.serialize(generator, mapper);
        }
        if (this.canRemainDecisions != null) {
            generator.writeKey("can_remain_decisions");
            generator.writeStartArray();
            for (AllocationDecision allocationDecision : this.canRemainDecisions) {
                allocationDecision.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.canRemainOnCurrentNode != null) {
            generator.writeKey("can_remain_on_current_node");
            this.canRemainOnCurrentNode.serialize(generator, mapper);
        }
        if (this.clusterInfo != null) {
            generator.writeKey("cluster_info");
            this.clusterInfo.serialize(generator, mapper);
        }
        if (this.configuredDelay != null) {
            generator.writeKey("configured_delay");
            generator.write(this.configuredDelay);
        }
        if (this.configuredDelayInMillis != null) {
            generator.writeKey("configured_delay_in_millis");
            generator.write(this.configuredDelayInMillis.longValue());
        }
        if (this.currentNode != null) {
            generator.writeKey("current_node");
            this.currentNode.serialize(generator, mapper);
        }
        generator.writeKey("current_state");
        generator.write(this.currentState);
        generator.writeKey("index");
        generator.write(this.index);
        if (this.moveExplanation != null) {
            generator.writeKey("move_explanation");
            generator.write(this.moveExplanation);
        }
        if (this.nodeAllocationDecisions != null) {
            generator.writeKey("node_allocation_decisions");
            generator.writeStartArray();
            for (NodeAllocationExplanation nodeAllocationExplanation : this.nodeAllocationDecisions) {
                nodeAllocationExplanation.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("primary");
        generator.write(this.primary);
        if (this.rebalanceExplanation != null) {
            generator.writeKey("rebalance_explanation");
            generator.write(this.rebalanceExplanation);
        }
        if (this.remainingDelay != null) {
            generator.writeKey("remaining_delay");
            generator.write(this.remainingDelay);
        }
        if (this.remainingDelayInMillis != null) {
            generator.writeKey("remaining_delay_in_millis");
            generator.write(this.remainingDelayInMillis.longValue());
        }
        generator.writeKey("shard");
        generator.write(this.shard);
        if (this.unassignedInfo != null) {
            generator.writeKey("unassigned_info");
            this.unassignedInfo.serialize(generator, mapper);
        }
        if (this.note != null) {
            generator.writeKey("note");
            generator.write(this.note);
        }
    }

    protected static void setupAllocationExplainResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allocateExplanation, JsonpDeserializer.stringDeserializer(), "allocate_explanation", new String[0]);
        op.add(Builder::allocationDelay, JsonpDeserializer.stringDeserializer(), "allocation_delay", new String[0]);
        op.add(Builder::allocationDelayInMillis, JsonpDeserializer.longDeserializer(), "allocation_delay_in_millis", new String[0]);
        op.add(Builder::canAllocate, Decision._DESERIALIZER, "can_allocate", new String[0]);
        op.add(Builder::canMoveToOtherNode, Decision._DESERIALIZER, "can_move_to_other_node", new String[0]);
        op.add(Builder::canRebalanceCluster, Decision._DESERIALIZER, "can_rebalance_cluster", new String[0]);
        op.add(Builder::canRebalanceClusterDecisions, JsonpDeserializer.arrayDeserializer(AllocationDecision._DESERIALIZER), "can_rebalance_cluster_decisions", new String[0]);
        op.add(Builder::canRebalanceToOtherNode, Decision._DESERIALIZER, "can_rebalance_to_other_node", new String[0]);
        op.add(Builder::canRemainDecisions, JsonpDeserializer.arrayDeserializer(AllocationDecision._DESERIALIZER), "can_remain_decisions", new String[0]);
        op.add(Builder::canRemainOnCurrentNode, Decision._DESERIALIZER, "can_remain_on_current_node", new String[0]);
        op.add(Builder::clusterInfo, ClusterInfo._DESERIALIZER, "cluster_info", new String[0]);
        op.add(Builder::configuredDelay, JsonpDeserializer.stringDeserializer(), "configured_delay", new String[0]);
        op.add(Builder::configuredDelayInMillis, JsonpDeserializer.longDeserializer(), "configured_delay_in_millis", new String[0]);
        op.add(Builder::currentNode, CurrentNode._DESERIALIZER, "current_node", new String[0]);
        op.add(Builder::currentState, JsonpDeserializer.stringDeserializer(), "current_state", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::moveExplanation, JsonpDeserializer.stringDeserializer(), "move_explanation", new String[0]);
        op.add(Builder::nodeAllocationDecisions, JsonpDeserializer.arrayDeserializer(NodeAllocationExplanation._DESERIALIZER), "node_allocation_decisions", new String[0]);
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary", new String[0]);
        op.add(Builder::rebalanceExplanation, JsonpDeserializer.stringDeserializer(), "rebalance_explanation", new String[0]);
        op.add(Builder::remainingDelay, JsonpDeserializer.stringDeserializer(), "remaining_delay", new String[0]);
        op.add(Builder::remainingDelayInMillis, JsonpDeserializer.longDeserializer(), "remaining_delay_in_millis", new String[0]);
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard", new String[0]);
        op.add(Builder::unassignedInfo, UnassignedInformation._DESERIALIZER, "unassigned_info", new String[0]);
        op.add(Builder::note, JsonpDeserializer.stringDeserializer(), "note", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AllocationExplainResponse> {
        @Nullable
        private String allocateExplanation;
        @Nullable
        private String allocationDelay;
        @Nullable
        private Long allocationDelayInMillis;
        @Nullable
        private Decision canAllocate;
        @Nullable
        private Decision canMoveToOtherNode;
        @Nullable
        private Decision canRebalanceCluster;
        @Nullable
        private List<AllocationDecision> canRebalanceClusterDecisions;
        @Nullable
        private Decision canRebalanceToOtherNode;
        @Nullable
        private List<AllocationDecision> canRemainDecisions;
        @Nullable
        private Decision canRemainOnCurrentNode;
        @Nullable
        private ClusterInfo clusterInfo;
        @Nullable
        private String configuredDelay;
        @Nullable
        private Long configuredDelayInMillis;
        @Nullable
        private CurrentNode currentNode;
        private String currentState;
        private String index;
        @Nullable
        private String moveExplanation;
        @Nullable
        private List<NodeAllocationExplanation> nodeAllocationDecisions;
        private Boolean primary;
        @Nullable
        private String rebalanceExplanation;
        @Nullable
        private String remainingDelay;
        @Nullable
        private Long remainingDelayInMillis;
        private Integer shard;
        @Nullable
        private UnassignedInformation unassignedInfo;
        @Nullable
        private String note;

        public Builder allocateExplanation(@Nullable String value) {
            this.allocateExplanation = value;
            return this;
        }

        public Builder allocationDelay(@Nullable String value) {
            this.allocationDelay = value;
            return this;
        }

        public Builder allocationDelayInMillis(@Nullable Long value) {
            this.allocationDelayInMillis = value;
            return this;
        }

        public Builder canAllocate(@Nullable Decision value) {
            this.canAllocate = value;
            return this;
        }

        public Builder canMoveToOtherNode(@Nullable Decision value) {
            this.canMoveToOtherNode = value;
            return this;
        }

        public Builder canRebalanceCluster(@Nullable Decision value) {
            this.canRebalanceCluster = value;
            return this;
        }

        public Builder canRebalanceClusterDecisions(@Nullable List<AllocationDecision> value) {
            this.canRebalanceClusterDecisions = value;
            return this;
        }

        public Builder canRebalanceClusterDecisions(AllocationDecision ... value) {
            this.canRebalanceClusterDecisions = Arrays.asList(value);
            return this;
        }

        public Builder addCanRebalanceClusterDecisions(AllocationDecision value) {
            if (this.canRebalanceClusterDecisions == null) {
                this.canRebalanceClusterDecisions = new ArrayList<AllocationDecision>();
            }
            this.canRebalanceClusterDecisions.add(value);
            return this;
        }

        public Builder canRebalanceClusterDecisions(Function<AllocationDecision.Builder, ObjectBuilder<AllocationDecision>> fn) {
            return this.canRebalanceClusterDecisions(fn.apply(new AllocationDecision.Builder()).build());
        }

        public Builder addCanRebalanceClusterDecisions(Function<AllocationDecision.Builder, ObjectBuilder<AllocationDecision>> fn) {
            return this.addCanRebalanceClusterDecisions(fn.apply(new AllocationDecision.Builder()).build());
        }

        public Builder canRebalanceToOtherNode(@Nullable Decision value) {
            this.canRebalanceToOtherNode = value;
            return this;
        }

        public Builder canRemainDecisions(@Nullable List<AllocationDecision> value) {
            this.canRemainDecisions = value;
            return this;
        }

        public Builder canRemainDecisions(AllocationDecision ... value) {
            this.canRemainDecisions = Arrays.asList(value);
            return this;
        }

        public Builder addCanRemainDecisions(AllocationDecision value) {
            if (this.canRemainDecisions == null) {
                this.canRemainDecisions = new ArrayList<AllocationDecision>();
            }
            this.canRemainDecisions.add(value);
            return this;
        }

        public Builder canRemainDecisions(Function<AllocationDecision.Builder, ObjectBuilder<AllocationDecision>> fn) {
            return this.canRemainDecisions(fn.apply(new AllocationDecision.Builder()).build());
        }

        public Builder addCanRemainDecisions(Function<AllocationDecision.Builder, ObjectBuilder<AllocationDecision>> fn) {
            return this.addCanRemainDecisions(fn.apply(new AllocationDecision.Builder()).build());
        }

        public Builder canRemainOnCurrentNode(@Nullable Decision value) {
            this.canRemainOnCurrentNode = value;
            return this;
        }

        public Builder clusterInfo(@Nullable ClusterInfo value) {
            this.clusterInfo = value;
            return this;
        }

        public Builder clusterInfo(Function<ClusterInfo.Builder, ObjectBuilder<ClusterInfo>> fn) {
            return this.clusterInfo(fn.apply(new ClusterInfo.Builder()).build());
        }

        public Builder configuredDelay(@Nullable String value) {
            this.configuredDelay = value;
            return this;
        }

        public Builder configuredDelayInMillis(@Nullable Long value) {
            this.configuredDelayInMillis = value;
            return this;
        }

        public Builder currentNode(@Nullable CurrentNode value) {
            this.currentNode = value;
            return this;
        }

        public Builder currentNode(Function<CurrentNode.Builder, ObjectBuilder<CurrentNode>> fn) {
            return this.currentNode(fn.apply(new CurrentNode.Builder()).build());
        }

        public Builder currentState(String value) {
            this.currentState = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder moveExplanation(@Nullable String value) {
            this.moveExplanation = value;
            return this;
        }

        public Builder nodeAllocationDecisions(@Nullable List<NodeAllocationExplanation> value) {
            this.nodeAllocationDecisions = value;
            return this;
        }

        public Builder nodeAllocationDecisions(NodeAllocationExplanation ... value) {
            this.nodeAllocationDecisions = Arrays.asList(value);
            return this;
        }

        public Builder addNodeAllocationDecisions(NodeAllocationExplanation value) {
            if (this.nodeAllocationDecisions == null) {
                this.nodeAllocationDecisions = new ArrayList<NodeAllocationExplanation>();
            }
            this.nodeAllocationDecisions.add(value);
            return this;
        }

        public Builder nodeAllocationDecisions(Function<NodeAllocationExplanation.Builder, ObjectBuilder<NodeAllocationExplanation>> fn) {
            return this.nodeAllocationDecisions(fn.apply(new NodeAllocationExplanation.Builder()).build());
        }

        public Builder addNodeAllocationDecisions(Function<NodeAllocationExplanation.Builder, ObjectBuilder<NodeAllocationExplanation>> fn) {
            return this.addNodeAllocationDecisions(fn.apply(new NodeAllocationExplanation.Builder()).build());
        }

        public Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        public Builder rebalanceExplanation(@Nullable String value) {
            this.rebalanceExplanation = value;
            return this;
        }

        public Builder remainingDelay(@Nullable String value) {
            this.remainingDelay = value;
            return this;
        }

        public Builder remainingDelayInMillis(@Nullable Long value) {
            this.remainingDelayInMillis = value;
            return this;
        }

        public Builder shard(int value) {
            this.shard = value;
            return this;
        }

        public Builder unassignedInfo(@Nullable UnassignedInformation value) {
            this.unassignedInfo = value;
            return this;
        }

        public Builder unassignedInfo(Function<UnassignedInformation.Builder, ObjectBuilder<UnassignedInformation>> fn) {
            return this.unassignedInfo(fn.apply(new UnassignedInformation.Builder()).build());
        }

        public Builder note(@Nullable String value) {
            this.note = value;
            return this;
        }

        @Override
        public AllocationExplainResponse build() {
            return new AllocationExplainResponse(this);
        }
    }
}

