/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AutoFollowedCluster
implements JsonpSerializable {
    private final String clusterName;
    private final long lastSeenMetadataVersion;
    private final String timeSinceLastCheckMillis;
    public static final JsonpDeserializer<AutoFollowedCluster> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoFollowedCluster::setupAutoFollowedClusterDeserializer, Builder::build);

    public AutoFollowedCluster(Builder builder) {
        this.clusterName = Objects.requireNonNull(builder.clusterName, "cluster_name");
        this.lastSeenMetadataVersion = Objects.requireNonNull(builder.lastSeenMetadataVersion, "last_seen_metadata_version");
        this.timeSinceLastCheckMillis = Objects.requireNonNull(builder.timeSinceLastCheckMillis, "time_since_last_check_millis");
    }

    public AutoFollowedCluster(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String clusterName() {
        return this.clusterName;
    }

    public long lastSeenMetadataVersion() {
        return this.lastSeenMetadataVersion;
    }

    public String timeSinceLastCheckMillis() {
        return this.timeSinceLastCheckMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("last_seen_metadata_version");
        generator.write(this.lastSeenMetadataVersion);
        generator.writeKey("time_since_last_check_millis");
        generator.write(this.timeSinceLastCheckMillis);
    }

    protected static void setupAutoFollowedClusterDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name", new String[0]);
        op.add(Builder::lastSeenMetadataVersion, JsonpDeserializer.longDeserializer(), "last_seen_metadata_version", new String[0]);
        op.add(Builder::timeSinceLastCheckMillis, JsonpDeserializer.stringDeserializer(), "time_since_last_check_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AutoFollowedCluster> {
        private String clusterName;
        private Long lastSeenMetadataVersion;
        private String timeSinceLastCheckMillis;

        public Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public Builder lastSeenMetadataVersion(long value) {
            this.lastSeenMetadataVersion = value;
            return this;
        }

        public Builder timeSinceLastCheckMillis(String value) {
            this.timeSinceLastCheckMillis = value;
            return this;
        }

        @Override
        public AutoFollowedCluster build() {
            return new AutoFollowedCluster(this);
        }
    }
}

