/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat.ml_datafeeds;

import co.elastic.clients.elasticsearch.ml.DatafeedState;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DatafeedsRecord
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final DatafeedState state;
    @Nullable
    private final String assignmentExplanation;
    @Nullable
    private final String bucketsCount;
    @Nullable
    private final String searchCount;
    @Nullable
    private final String searchTime;
    @Nullable
    private final String searchBucketAvg;
    @Nullable
    private final String searchExpAvgHour;
    @Nullable
    private final String nodeId;
    @Nullable
    private final String nodeName;
    @Nullable
    private final String nodeEphemeralId;
    @Nullable
    private final String nodeAddress;
    public static final JsonpDeserializer<DatafeedsRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatafeedsRecord::setupDatafeedsRecordDeserializer, Builder::build);

    public DatafeedsRecord(Builder builder) {
        this.id = builder.id;
        this.state = builder.state;
        this.assignmentExplanation = builder.assignmentExplanation;
        this.bucketsCount = builder.bucketsCount;
        this.searchCount = builder.searchCount;
        this.searchTime = builder.searchTime;
        this.searchBucketAvg = builder.searchBucketAvg;
        this.searchExpAvgHour = builder.searchExpAvgHour;
        this.nodeId = builder.nodeId;
        this.nodeName = builder.nodeName;
        this.nodeEphemeralId = builder.nodeEphemeralId;
        this.nodeAddress = builder.nodeAddress;
    }

    public DatafeedsRecord(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public DatafeedState state() {
        return this.state;
    }

    @Nullable
    public String assignmentExplanation() {
        return this.assignmentExplanation;
    }

    @Nullable
    public String bucketsCount() {
        return this.bucketsCount;
    }

    @Nullable
    public String searchCount() {
        return this.searchCount;
    }

    @Nullable
    public String searchTime() {
        return this.searchTime;
    }

    @Nullable
    public String searchBucketAvg() {
        return this.searchBucketAvg;
    }

    @Nullable
    public String searchExpAvgHour() {
        return this.searchExpAvgHour;
    }

    @Nullable
    public String nodeId() {
        return this.nodeId;
    }

    @Nullable
    public String nodeName() {
        return this.nodeName;
    }

    @Nullable
    public String nodeEphemeralId() {
        return this.nodeEphemeralId;
    }

    @Nullable
    public String nodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.state != null) {
            generator.writeKey("state");
            this.state.serialize(generator, mapper);
        }
        if (this.assignmentExplanation != null) {
            generator.writeKey("assignment_explanation");
            generator.write(this.assignmentExplanation);
        }
        if (this.bucketsCount != null) {
            generator.writeKey("buckets.count");
            generator.write(this.bucketsCount);
        }
        if (this.searchCount != null) {
            generator.writeKey("search.count");
            generator.write(this.searchCount);
        }
        if (this.searchTime != null) {
            generator.writeKey("search.time");
            generator.write(this.searchTime);
        }
        if (this.searchBucketAvg != null) {
            generator.writeKey("search.bucket_avg");
            generator.write(this.searchBucketAvg);
        }
        if (this.searchExpAvgHour != null) {
            generator.writeKey("search.exp_avg_hour");
            generator.write(this.searchExpAvgHour);
        }
        if (this.nodeId != null) {
            generator.writeKey("node.id");
            generator.write(this.nodeId);
        }
        if (this.nodeName != null) {
            generator.writeKey("node.name");
            generator.write(this.nodeName);
        }
        if (this.nodeEphemeralId != null) {
            generator.writeKey("node.ephemeral_id");
            generator.write(this.nodeEphemeralId);
        }
        if (this.nodeAddress != null) {
            generator.writeKey("node.address");
            generator.write(this.nodeAddress);
        }
    }

    protected static void setupDatafeedsRecordDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::state, DatafeedState._DESERIALIZER, "state", "s");
        op.add(Builder::assignmentExplanation, JsonpDeserializer.stringDeserializer(), "assignment_explanation", "ae");
        op.add(Builder::bucketsCount, JsonpDeserializer.stringDeserializer(), "buckets.count", "bc", "bucketsCount");
        op.add(Builder::searchCount, JsonpDeserializer.stringDeserializer(), "search.count", "sc", "searchCount");
        op.add(Builder::searchTime, JsonpDeserializer.stringDeserializer(), "search.time", "st", "searchTime");
        op.add(Builder::searchBucketAvg, JsonpDeserializer.stringDeserializer(), "search.bucket_avg", "sba", "searchBucketAvg");
        op.add(Builder::searchExpAvgHour, JsonpDeserializer.stringDeserializer(), "search.exp_avg_hour", "seah", "searchExpAvgHour");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node.id", "ni", "nodeId");
        op.add(Builder::nodeName, JsonpDeserializer.stringDeserializer(), "node.name", "nn", "nodeName");
        op.add(Builder::nodeEphemeralId, JsonpDeserializer.stringDeserializer(), "node.ephemeral_id", "ne", "nodeEphemeralId");
        op.add(Builder::nodeAddress, JsonpDeserializer.stringDeserializer(), "node.address", "na", "nodeAddress");
    }

    public static class Builder
    implements ObjectBuilder<DatafeedsRecord> {
        @Nullable
        private String id;
        @Nullable
        private DatafeedState state;
        @Nullable
        private String assignmentExplanation;
        @Nullable
        private String bucketsCount;
        @Nullable
        private String searchCount;
        @Nullable
        private String searchTime;
        @Nullable
        private String searchBucketAvg;
        @Nullable
        private String searchExpAvgHour;
        @Nullable
        private String nodeId;
        @Nullable
        private String nodeName;
        @Nullable
        private String nodeEphemeralId;
        @Nullable
        private String nodeAddress;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder state(@Nullable DatafeedState value) {
            this.state = value;
            return this;
        }

        public Builder assignmentExplanation(@Nullable String value) {
            this.assignmentExplanation = value;
            return this;
        }

        public Builder bucketsCount(@Nullable String value) {
            this.bucketsCount = value;
            return this;
        }

        public Builder searchCount(@Nullable String value) {
            this.searchCount = value;
            return this;
        }

        public Builder searchTime(@Nullable String value) {
            this.searchTime = value;
            return this;
        }

        public Builder searchBucketAvg(@Nullable String value) {
            this.searchBucketAvg = value;
            return this;
        }

        public Builder searchExpAvgHour(@Nullable String value) {
            this.searchExpAvgHour = value;
            return this;
        }

        public Builder nodeId(@Nullable String value) {
            this.nodeId = value;
            return this;
        }

        public Builder nodeName(@Nullable String value) {
            this.nodeName = value;
            return this;
        }

        public Builder nodeEphemeralId(@Nullable String value) {
            this.nodeEphemeralId = value;
            return this;
        }

        public Builder nodeAddress(@Nullable String value) {
            this.nodeAddress = value;
            return this;
        }

        @Override
        public DatafeedsRecord build() {
            return new DatafeedsRecord(this);
        }
    }
}

