/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlJobsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class MlJobsRequest
extends CatRequestBase {
    @Nullable
    private final String jobId;
    @Nullable
    private final Boolean allowNoJobs;
    @Nullable
    private final Bytes bytes;
    public static final Endpoint<MlJobsRequest, MlJobsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<MlJobsRequest, MlJobsResponse>(request -> "GET", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (request.jobId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/anomaly_detectors");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoJobs != null) {
            params.put("allow_no_jobs", String.valueOf(request.allowNoJobs));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.toString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlJobsResponse._DESERIALIZER);

    public MlJobsRequest(Builder builder) {
        this.jobId = builder.jobId;
        this.allowNoJobs = builder.allowNoJobs;
        this.bytes = builder.bytes;
    }

    public MlJobsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public Boolean allowNoJobs() {
        return this.allowNoJobs;
    }

    @Nullable
    public Bytes bytes() {
        return this.bytes;
    }

    public static class Builder
    implements ObjectBuilder<MlJobsRequest> {
        @Nullable
        private String jobId;
        @Nullable
        private Boolean allowNoJobs;
        @Nullable
        private Bytes bytes;

        public Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        public Builder allowNoJobs(@Nullable Boolean value) {
            this.allowNoJobs = value;
            return this;
        }

        public Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        @Override
        public MlJobsRequest build() {
            return new MlJobsRequest(this);
        }
    }
}

