/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SimpleQueryStringFlags;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SimpleQueryStringQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final Boolean autoGenerateSynonymsPhraseQuery;
    @Nullable
    private final Operator defaultOperator;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final SimpleQueryStringFlags flags;
    @Nullable
    private final Integer fuzzyMaxExpansions;
    @Nullable
    private final Integer fuzzyPrefixLength;
    @Nullable
    private final Boolean fuzzyTranspositions;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final String minimumShouldMatch;
    private final String query;
    @Nullable
    private final String quoteFieldSuffix;
    public static final JsonpDeserializer<SimpleQueryStringQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimpleQueryStringQuery::setupSimpleQueryStringQueryDeserializer, Builder::build);

    public SimpleQueryStringQuery(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.autoGenerateSynonymsPhraseQuery = builder.autoGenerateSynonymsPhraseQuery;
        this.defaultOperator = builder.defaultOperator;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.flags = builder.flags;
        this.fuzzyMaxExpansions = builder.fuzzyMaxExpansions;
        this.fuzzyPrefixLength = builder.fuzzyPrefixLength;
        this.fuzzyTranspositions = builder.fuzzyTranspositions;
        this.lenient = builder.lenient;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.query = Objects.requireNonNull(builder.query, "query");
        this.quoteFieldSuffix = builder.quoteFieldSuffix;
    }

    public SimpleQueryStringQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "simple_query_string";
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public Boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    @Nullable
    public Operator defaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public SimpleQueryStringFlags flags() {
        return this.flags;
    }

    @Nullable
    public Integer fuzzyMaxExpansions() {
        return this.fuzzyMaxExpansions;
    }

    @Nullable
    public Integer fuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    @Nullable
    public Boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    @Nullable
    public Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public String query() {
        return this.query;
    }

    @Nullable
    public String quoteFieldSuffix() {
        return this.quoteFieldSuffix;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.analyzeWildcard != null) {
            generator.writeKey("analyze_wildcard");
            generator.write(this.analyzeWildcard.booleanValue());
        }
        if (this.autoGenerateSynonymsPhraseQuery != null) {
            generator.writeKey("auto_generate_synonyms_phrase_query");
            generator.write(this.autoGenerateSynonymsPhraseQuery.booleanValue());
        }
        if (this.defaultOperator != null) {
            generator.writeKey("default_operator");
            this.defaultOperator.serialize(generator, mapper);
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.flags != null) {
            generator.writeKey("flags");
            this.flags.serialize(generator, mapper);
        }
        if (this.fuzzyMaxExpansions != null) {
            generator.writeKey("fuzzy_max_expansions");
            generator.write(this.fuzzyMaxExpansions.intValue());
        }
        if (this.fuzzyPrefixLength != null) {
            generator.writeKey("fuzzy_prefix_length");
            generator.write(this.fuzzyPrefixLength.intValue());
        }
        if (this.fuzzyTranspositions != null) {
            generator.writeKey("fuzzy_transpositions");
            generator.write(this.fuzzyTranspositions.booleanValue());
        }
        if (this.lenient != null) {
            generator.writeKey("lenient");
            generator.write(this.lenient.booleanValue());
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.quoteFieldSuffix != null) {
            generator.writeKey("quote_field_suffix");
            generator.write(this.quoteFieldSuffix);
        }
    }

    protected static void setupSimpleQueryStringQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::analyzeWildcard, JsonpDeserializer.booleanDeserializer(), "analyze_wildcard", new String[0]);
        op.add(Builder::autoGenerateSynonymsPhraseQuery, JsonpDeserializer.booleanDeserializer(), "auto_generate_synonyms_phrase_query", new String[0]);
        op.add(Builder::defaultOperator, Operator._DESERIALIZER, "default_operator", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields", new String[0]);
        op.add(Builder::flags, SimpleQueryStringFlags._DESERIALIZER, "flags", new String[0]);
        op.add(Builder::fuzzyMaxExpansions, JsonpDeserializer.integerDeserializer(), "fuzzy_max_expansions", new String[0]);
        op.add(Builder::fuzzyPrefixLength, JsonpDeserializer.integerDeserializer(), "fuzzy_prefix_length", new String[0]);
        op.add(Builder::fuzzyTranspositions, JsonpDeserializer.booleanDeserializer(), "fuzzy_transpositions", new String[0]);
        op.add(Builder::lenient, JsonpDeserializer.booleanDeserializer(), "lenient", new String[0]);
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match", new String[0]);
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query", new String[0]);
        op.add(Builder::quoteFieldSuffix, JsonpDeserializer.stringDeserializer(), "quote_field_suffix", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SimpleQueryStringQuery> {
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private Boolean autoGenerateSynonymsPhraseQuery;
        @Nullable
        private Operator defaultOperator;
        @Nullable
        private List<String> fields;
        @Nullable
        private SimpleQueryStringFlags flags;
        @Nullable
        private Integer fuzzyMaxExpansions;
        @Nullable
        private Integer fuzzyPrefixLength;
        @Nullable
        private Boolean fuzzyTranspositions;
        @Nullable
        private Boolean lenient;
        @Nullable
        private String minimumShouldMatch;
        private String query;
        @Nullable
        private String quoteFieldSuffix;

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        public Builder autoGenerateSynonymsPhraseQuery(@Nullable Boolean value) {
            this.autoGenerateSynonymsPhraseQuery = value;
            return this;
        }

        public Builder defaultOperator(@Nullable Operator value) {
            this.defaultOperator = value;
            return this;
        }

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder flags(@Nullable SimpleQueryStringFlags value) {
            this.flags = value;
            return this;
        }

        public Builder fuzzyMaxExpansions(@Nullable Integer value) {
            this.fuzzyMaxExpansions = value;
            return this;
        }

        public Builder fuzzyPrefixLength(@Nullable Integer value) {
            this.fuzzyPrefixLength = value;
            return this;
        }

        public Builder fuzzyTranspositions(@Nullable Boolean value) {
            this.fuzzyTranspositions = value;
            return this;
        }

        public Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public Builder query(String value) {
            this.query = value;
            return this;
        }

        public Builder quoteFieldSuffix(@Nullable String value) {
            this.quoteFieldSuffix = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SimpleQueryStringQuery build() {
            return new SimpleQueryStringQuery(this);
        }
    }
}

