/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.ScoreFunctionBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ScriptScoreFunction
extends ScoreFunctionBase
implements FunctionScoreVariant {
    private final JsonValue script;
    public static final JsonpDeserializer<ScriptScoreFunction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptScoreFunction::setupScriptScoreFunctionDeserializer, Builder::build);

    public ScriptScoreFunction(Builder builder) {
        super(builder);
        this.script = Objects.requireNonNull(builder.script, "script");
    }

    public ScriptScoreFunction(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "script_score";
    }

    public JsonValue script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("script");
        generator.write(this.script);
    }

    protected static void setupScriptScoreFunctionDeserializer(DelegatingDeserializer<Builder> op) {
        ScoreFunctionBase.setupScoreFunctionBaseDeserializer(op);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), "script", new String[0]);
    }

    public static class Builder
    extends ScoreFunctionBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ScriptScoreFunction> {
        private JsonValue script;

        public Builder script(JsonValue value) {
            this.script = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptScoreFunction build() {
            return new ScriptScoreFunction(this);
        }
    }
}

