/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.GeoShapeRelation;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldLookup;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GeoShapeFieldQuery
implements JsonpSerializable {
    @Nullable
    private final JsonData shape;
    @Nullable
    private final FieldLookup indexedShape;
    @Nullable
    private final GeoShapeRelation relation;
    public static final JsonpDeserializer<GeoShapeFieldQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoShapeFieldQuery::setupGeoShapeFieldQueryDeserializer, Builder::build);

    public GeoShapeFieldQuery(Builder builder) {
        this.shape = builder.shape;
        this.indexedShape = builder.indexedShape;
        this.relation = builder.relation;
    }

    public GeoShapeFieldQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public JsonData shape() {
        return this.shape;
    }

    @Nullable
    public FieldLookup indexedShape() {
        return this.indexedShape;
    }

    @Nullable
    public GeoShapeRelation relation() {
        return this.relation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.shape != null) {
            generator.writeKey("shape");
            this.shape.serialize(generator, mapper);
        }
        if (this.indexedShape != null) {
            generator.writeKey("indexed_shape");
            this.indexedShape.serialize(generator, mapper);
        }
        if (this.relation != null) {
            generator.writeKey("relation");
            this.relation.serialize(generator, mapper);
        }
    }

    protected static void setupGeoShapeFieldQueryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::shape, JsonData._DESERIALIZER, "shape", new String[0]);
        op.add(Builder::indexedShape, FieldLookup._DESERIALIZER, "indexed_shape", new String[0]);
        op.add(Builder::relation, GeoShapeRelation._DESERIALIZER, "relation", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GeoShapeFieldQuery> {
        @Nullable
        private JsonData shape;
        @Nullable
        private FieldLookup indexedShape;
        @Nullable
        private GeoShapeRelation relation;

        public Builder shape(@Nullable JsonData value) {
            this.shape = value;
            return this;
        }

        public Builder indexedShape(@Nullable FieldLookup value) {
            this.indexedShape = value;
            return this;
        }

        public Builder indexedShape(Function<FieldLookup.Builder, ObjectBuilder<FieldLookup>> fn) {
            return this.indexedShape(fn.apply(new FieldLookup.Builder()).build());
        }

        public Builder relation(@Nullable GeoShapeRelation value) {
            this.relation = value;
            return this;
        }

        @Override
        public GeoShapeFieldQuery build() {
            return new GeoShapeFieldQuery(this);
        }
    }
}

