/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.FunctionBoostMode;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScore;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FunctionScoreQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final FunctionBoostMode boostMode;
    @Nullable
    private final List<FunctionScore> functions;
    @Nullable
    private final Double maxBoost;
    @Nullable
    private final Double minScore;
    @Nullable
    private final Query query;
    @Nullable
    private final FunctionScoreMode scoreMode;
    public static final JsonpDeserializer<FunctionScoreQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FunctionScoreQuery::setupFunctionScoreQueryDeserializer, Builder::build);

    public FunctionScoreQuery(Builder builder) {
        super(builder);
        this.boostMode = builder.boostMode;
        this.functions = ModelTypeHelper.unmodifiable(builder.functions);
        this.maxBoost = builder.maxBoost;
        this.minScore = builder.minScore;
        this.query = builder.query;
        this.scoreMode = builder.scoreMode;
    }

    public FunctionScoreQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "function_score";
    }

    @Nullable
    public FunctionBoostMode boostMode() {
        return this.boostMode;
    }

    @Nullable
    public List<FunctionScore> functions() {
        return this.functions;
    }

    @Nullable
    public Double maxBoost() {
        return this.maxBoost;
    }

    @Nullable
    public Double minScore() {
        return this.minScore;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Nullable
    public FunctionScoreMode scoreMode() {
        return this.scoreMode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.boostMode != null) {
            generator.writeKey("boost_mode");
            this.boostMode.serialize(generator, mapper);
        }
        if (this.functions != null) {
            generator.writeKey("functions");
            generator.writeStartArray();
            for (FunctionScore item0 : this.functions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxBoost != null) {
            generator.writeKey("max_boost");
            generator.write(this.maxBoost.doubleValue());
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write(this.minScore.doubleValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
    }

    protected static void setupFunctionScoreQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::boostMode, FunctionBoostMode._DESERIALIZER, "boost_mode", new String[0]);
        op.add(Builder::functions, JsonpDeserializer.arrayDeserializer(FunctionScore._DESERIALIZER), "functions", new String[0]);
        op.add(Builder::maxBoost, JsonpDeserializer.doubleDeserializer(), "max_boost", new String[0]);
        op.add(Builder::minScore, JsonpDeserializer.doubleDeserializer(), "min_score", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::scoreMode, FunctionScoreMode._DESERIALIZER, "score_mode", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FunctionScoreQuery> {
        @Nullable
        private FunctionBoostMode boostMode;
        @Nullable
        private List<FunctionScore> functions;
        @Nullable
        private Double maxBoost;
        @Nullable
        private Double minScore;
        @Nullable
        private Query query;
        @Nullable
        private FunctionScoreMode scoreMode;

        public Builder boostMode(@Nullable FunctionBoostMode value) {
            this.boostMode = value;
            return this;
        }

        public Builder functions(@Nullable List<FunctionScore> value) {
            this.functions = value;
            return this;
        }

        public Builder functions(FunctionScore ... value) {
            this.functions = Arrays.asList(value);
            return this;
        }

        public Builder addFunctions(FunctionScore value) {
            if (this.functions == null) {
                this.functions = new ArrayList<FunctionScore>();
            }
            this.functions.add(value);
            return this;
        }

        public Builder functions(Function<FunctionScore.Builder, ObjectBuilder<FunctionScore>> fn) {
            return this.functions(fn.apply(new FunctionScore.Builder()).build());
        }

        public Builder addFunctions(Function<FunctionScore.Builder, ObjectBuilder<FunctionScore>> fn) {
            return this.addFunctions(fn.apply(new FunctionScore.Builder()).build());
        }

        public Builder maxBoost(@Nullable Double value) {
            this.maxBoost = value;
            return this;
        }

        public Builder minScore(@Nullable Double value) {
            this.minScore = value;
            return this;
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder scoreMode(@Nullable FunctionScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FunctionScoreQuery build() {
            return new FunctionScoreQuery(this);
        }
    }
}

