/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class StemmerOverrideTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final List<String> rules;
    private final String rulesPath;
    public static final JsonpDeserializer<StemmerOverrideTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StemmerOverrideTokenFilter::setupStemmerOverrideTokenFilterDeserializer, Builder::build);

    public StemmerOverrideTokenFilter(Builder builder) {
        super(builder);
        this.rules = ModelTypeHelper.unmodifiableNonNull(builder.rules, "rules");
        this.rulesPath = Objects.requireNonNull(builder.rulesPath, "rules_path");
    }

    public StemmerOverrideTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "stemmer_override";
    }

    public List<String> rules() {
        return this.rules;
    }

    public String rulesPath() {
        return this.rulesPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "stemmer_override");
        super.serializeInternal(generator, mapper);
        generator.writeKey("rules");
        generator.writeStartArray();
        for (String item0 : this.rules) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("rules_path");
        generator.write(this.rulesPath);
    }

    protected static void setupStemmerOverrideTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::rules, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "rules", new String[0]);
        op.add(Builder::rulesPath, JsonpDeserializer.stringDeserializer(), "rules_path", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StemmerOverrideTokenFilter> {
        private List<String> rules;
        private String rulesPath;

        public Builder rules(List<String> value) {
            this.rules = value;
            return this;
        }

        public Builder rules(String ... value) {
            this.rules = Arrays.asList(value);
            return this;
        }

        public Builder addRules(String value) {
            if (this.rules == null) {
                this.rules = new ArrayList<String>();
            }
            this.rules.add(value);
            return this;
        }

        public Builder rulesPath(String value) {
            this.rulesPath = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StemmerOverrideTokenFilter build() {
            return new StemmerOverrideTokenFilter(this);
        }
    }
}

