/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.elasticsearch._types.analysis.NoriDecompoundMode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NoriAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final String version;
    private final NoriDecompoundMode decompoundMode;
    private final List<String> stoptags;
    private final String userDictionary;
    public static final JsonpDeserializer<NoriAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NoriAnalyzer::setupNoriAnalyzerDeserializer, Builder::build);

    public NoriAnalyzer(Builder builder) {
        this.version = Objects.requireNonNull(builder.version, "version");
        this.decompoundMode = Objects.requireNonNull(builder.decompoundMode, "decompound_mode");
        this.stoptags = ModelTypeHelper.unmodifiableNonNull(builder.stoptags, "stoptags");
        this.userDictionary = Objects.requireNonNull(builder.userDictionary, "user_dictionary");
    }

    public NoriAnalyzer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "nori";
    }

    public String version() {
        return this.version;
    }

    public NoriDecompoundMode decompoundMode() {
        return this.decompoundMode;
    }

    public List<String> stoptags() {
        return this.stoptags;
    }

    public String userDictionary() {
        return this.userDictionary;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "nori");
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("decompound_mode");
        this.decompoundMode.serialize(generator, mapper);
        generator.writeKey("stoptags");
        generator.writeStartArray();
        for (String item0 : this.stoptags) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("user_dictionary");
        generator.write(this.userDictionary);
    }

    protected static void setupNoriAnalyzerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::decompoundMode, NoriDecompoundMode._DESERIALIZER, "decompound_mode", new String[0]);
        op.add(Builder::stoptags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stoptags", new String[0]);
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    implements ObjectBuilder<NoriAnalyzer> {
        private String version;
        private NoriDecompoundMode decompoundMode;
        private List<String> stoptags;
        private String userDictionary;

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        public Builder decompoundMode(NoriDecompoundMode value) {
            this.decompoundMode = value;
            return this;
        }

        public Builder stoptags(List<String> value) {
            this.stoptags = value;
            return this;
        }

        public Builder stoptags(String ... value) {
            this.stoptags = Arrays.asList(value);
            return this;
        }

        public Builder addStoptags(String value) {
            if (this.stoptags == null) {
                this.stoptags = new ArrayList<String>();
            }
            this.stoptags.add(value);
            return this;
        }

        public Builder userDictionary(String value) {
            this.userDictionary = value;
            return this;
        }

        @Override
        public NoriAnalyzer build() {
            return new NoriAnalyzer(this);
        }
    }
}

