/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.PipelineAggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MovingFunctionAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final String script;
    @Nullable
    private final Integer shift;
    @Nullable
    private final Integer window;
    public static final JsonpDeserializer<MovingFunctionAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MovingFunctionAggregation::setupMovingFunctionAggregationDeserializer, Builder::build);

    public MovingFunctionAggregation(Builder builder) {
        super(builder);
        this.script = builder.script;
        this.shift = builder.shift;
        this.window = builder.window;
    }

    public MovingFunctionAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "moving_fn";
    }

    @Nullable
    public String script() {
        return this.script;
    }

    @Nullable
    public Integer shift() {
        return this.shift;
    }

    @Nullable
    public Integer window() {
        return this.window;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.shift != null) {
            generator.writeKey("shift");
            generator.write(this.shift.intValue());
        }
        if (this.window != null) {
            generator.writeKey("window");
            generator.write(this.window.intValue());
        }
    }

    protected static void setupMovingFunctionAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::script, JsonpDeserializer.stringDeserializer(), "script", new String[0]);
        op.add(Builder::shift, JsonpDeserializer.integerDeserializer(), "shift", new String[0]);
        op.add(Builder::window, JsonpDeserializer.integerDeserializer(), "window", new String[0]);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MovingFunctionAggregation> {
        @Nullable
        private String script;
        @Nullable
        private Integer shift;
        @Nullable
        private Integer window;

        public Builder script(@Nullable String value) {
            this.script = value;
            return this;
        }

        public Builder shift(@Nullable Integer value) {
            this.shift = value;
            return this;
        }

        public Builder window(@Nullable Integer value) {
            this.window = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MovingFunctionAggregation build() {
            return new MovingFunctionAggregation(this);
        }
    }
}

