/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.ModelTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class MatrixAggregation
extends AggregationBase {
    @Nullable
    private final List<String> fields;
    @Nullable
    private final Map<String, Double> missing;

    public MatrixAggregation(AbstractBuilder<?> builder) {
        super(builder);
        this.fields = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).fields);
        this.missing = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).missing);
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public Map<String, Double> missing() {
        return this.missing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.writeStartObject();
            for (Map.Entry entry : this.missing.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write(((Double)entry.getValue()).doubleValue());
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMatrixAggregationDeserializer(DelegatingDeserializer<BuilderT> op) {
        AggregationBase.setupAggregationBaseDeserializer(op);
        op.add(AbstractBuilder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields", new String[0]);
        op.add(AbstractBuilder::missing, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "missing", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private List<String> fields;
        @Nullable
        private Map<String, Double> missing;

        protected AbstractBuilder() {
        }

        public BuilderT fields(@Nullable List<String> value) {
            this.fields = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT fields(String ... value) {
            this.fields = Arrays.asList(value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT missing(@Nullable Map<String, Double> value) {
            this.missing = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public BuilderT putMissing(String key, Double value) {
            if (this.missing == null) {
                this.missing = new HashMap<String, Double>();
            }
            this.missing.put(key, value);
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

