/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.GeoLinePoint;
import co.elastic.clients.elasticsearch._types.aggregations.GeoLineSort;
import co.elastic.clients.elasticsearch.core.search.SortOrder;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GeoLineAggregation
implements AggregationVariant,
JsonpSerializable {
    private final GeoLinePoint point;
    private final GeoLineSort sort;
    @Nullable
    private final Boolean includeSort;
    @Nullable
    private final SortOrder sortOrder;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<GeoLineAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoLineAggregation::setupGeoLineAggregationDeserializer, Builder::build);

    public GeoLineAggregation(Builder builder) {
        this.point = Objects.requireNonNull(builder.point, "point");
        this.sort = Objects.requireNonNull(builder.sort, "sort");
        this.includeSort = builder.includeSort;
        this.sortOrder = builder.sortOrder;
        this.size = builder.size;
    }

    public GeoLineAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "geo_line";
    }

    public GeoLinePoint point() {
        return this.point;
    }

    public GeoLineSort sort() {
        return this.sort;
    }

    @Nullable
    public Boolean includeSort() {
        return this.includeSort;
    }

    @Nullable
    public SortOrder sortOrder() {
        return this.sortOrder;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("point");
        this.point.serialize(generator, mapper);
        generator.writeKey("sort");
        this.sort.serialize(generator, mapper);
        if (this.includeSort != null) {
            generator.writeKey("include_sort");
            generator.write(this.includeSort.booleanValue());
        }
        if (this.sortOrder != null) {
            generator.writeKey("sort_order");
            this.sortOrder.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    protected static void setupGeoLineAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::point, GeoLinePoint._DESERIALIZER, "point", new String[0]);
        op.add(Builder::sort, GeoLineSort._DESERIALIZER, "sort", new String[0]);
        op.add(Builder::includeSort, JsonpDeserializer.booleanDeserializer(), "include_sort", new String[0]);
        op.add(Builder::sortOrder, SortOrder._DESERIALIZER, "sort_order", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GeoLineAggregation> {
        private GeoLinePoint point;
        private GeoLineSort sort;
        @Nullable
        private Boolean includeSort;
        @Nullable
        private SortOrder sortOrder;
        @Nullable
        private Integer size;

        public Builder point(GeoLinePoint value) {
            this.point = value;
            return this;
        }

        public Builder point(Function<GeoLinePoint.Builder, ObjectBuilder<GeoLinePoint>> fn) {
            return this.point(fn.apply(new GeoLinePoint.Builder()).build());
        }

        public Builder sort(GeoLineSort value) {
            this.sort = value;
            return this;
        }

        public Builder sort(Function<GeoLineSort.Builder, ObjectBuilder<GeoLineSort>> fn) {
            return this.sort(fn.apply(new GeoLineSort.Builder()).build());
        }

        public Builder includeSort(@Nullable Boolean value) {
            this.includeSort = value;
            return this;
        }

        public Builder sortOrder(@Nullable SortOrder value) {
            this.sortOrder = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        public GeoLineAggregation build() {
            return new GeoLineAggregation(this);
        }
    }
}

