/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.GapPolicy;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class BucketSortAggregation
extends AggregationBase
implements AggregationVariant {
    @Nullable
    private final Integer from;
    @Nullable
    private final GapPolicy gapPolicy;
    @Nullable
    private final Integer size;
    @Nullable
    private final List<JsonValue> sort;
    public static final JsonpDeserializer<BucketSortAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketSortAggregation::setupBucketSortAggregationDeserializer, Builder::build);

    public BucketSortAggregation(Builder builder) {
        super(builder);
        this.from = builder.from;
        this.gapPolicy = builder.gapPolicy;
        this.size = builder.size;
        this.sort = ModelTypeHelper.unmodifiable(builder.sort);
    }

    public BucketSortAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "bucket_sort";
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public List<JsonValue> sort() {
        return this.sort;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.gapPolicy != null) {
            generator.writeKey("gap_policy");
            this.gapPolicy.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (JsonValue item0 : this.sort) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupBucketSortAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        AggregationBase.setupAggregationBaseDeserializer(op);
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from", new String[0]);
        op.add(Builder::gapPolicy, GapPolicy._DESERIALIZER, "gap_policy", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "sort", new String[0]);
    }

    public static class Builder
    extends AggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BucketSortAggregation> {
        @Nullable
        private Integer from;
        @Nullable
        private GapPolicy gapPolicy;
        @Nullable
        private Integer size;
        @Nullable
        private List<JsonValue> sort;

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder gapPolicy(@Nullable GapPolicy value) {
            this.gapPolicy = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder sort(@Nullable List<JsonValue> value) {
            this.sort = value;
            return this;
        }

        public Builder sort(JsonValue ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder addSort(JsonValue value) {
            if (this.sort == null) {
                this.sort = new ArrayList<JsonValue>();
            }
            this.sort.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BucketSortAggregation build() {
            return new BucketSortAggregation(this);
        }
    }
}

