/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class AggregationBase
implements JsonpSerializable {
    @Nullable
    private final Map<String, JsonData> meta;
    @Nullable
    private final String name;

    public AggregationBase(AbstractBuilder<?> builder) {
        this.meta = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).meta);
        this.name = ((AbstractBuilder)builder).name;
    }

    @Nullable
    public Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.meta != null) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupAggregationBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "meta", new String[0]);
        op.add(AbstractBuilder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private String name;

        protected AbstractBuilder() {
        }

        public BuilderT meta(@Nullable Map<String, JsonData> value) {
            this.meta = value;
            return this.self();
        }

        public BuilderT putMeta(String key, JsonData value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, JsonData>();
            }
            this.meta.put(key, value);
            return this.self();
        }

        public BuilderT name(@Nullable String value) {
            this.name = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

